package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OSVersionConstraintDynamicVersionRequirement;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OSVersionConstraint
 */
@JsonPropertyOrder({ OSVersionConstraint.JSON_PROPERTY_DYNAMIC_VERSION_REQUIREMENT,
        OSVersionConstraint.JSON_PROPERTY_MAJOR_VERSION_CONSTRAINT, OSVersionConstraint.JSON_PROPERTY_MINIMUM })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OSVersionConstraint implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DYNAMIC_VERSION_REQUIREMENT = "dynamicVersionRequirement";
    private OSVersionConstraintDynamicVersionRequirement dynamicVersionRequirement;

    /**
     * Indicates the Windows major version
     */
    public enum MajorVersionConstraintEnum {
        _11("WINDOWS_11"),

        _10("WINDOWS_10"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        MajorVersionConstraintEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static MajorVersionConstraintEnum fromValue(String value) {
            for (MajorVersionConstraintEnum b : MajorVersionConstraintEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_MAJOR_VERSION_CONSTRAINT = "majorVersionConstraint";
    private MajorVersionConstraintEnum majorVersionConstraint;

    public static final String JSON_PROPERTY_MINIMUM = "minimum";
    private String minimum;

    public OSVersionConstraint() {
    }

    public OSVersionConstraint dynamicVersionRequirement(
            OSVersionConstraintDynamicVersionRequirement dynamicVersionRequirement) {

        this.dynamicVersionRequirement = dynamicVersionRequirement;
        return this;
    }

    /**
     * Get dynamicVersionRequirement
     *
     * @return dynamicVersionRequirement
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DYNAMIC_VERSION_REQUIREMENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OSVersionConstraintDynamicVersionRequirement getDynamicVersionRequirement() {
        return dynamicVersionRequirement;
    }

    @JsonProperty(JSON_PROPERTY_DYNAMIC_VERSION_REQUIREMENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDynamicVersionRequirement(OSVersionConstraintDynamicVersionRequirement dynamicVersionRequirement) {
        this.dynamicVersionRequirement = dynamicVersionRequirement;
    }

    public OSVersionConstraint majorVersionConstraint(MajorVersionConstraintEnum majorVersionConstraint) {

        this.majorVersionConstraint = majorVersionConstraint;
        return this;
    }

    /**
     * Indicates the Windows major version
     *
     * @return majorVersionConstraint
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Indicates the Windows major version")
    @JsonProperty(JSON_PROPERTY_MAJOR_VERSION_CONSTRAINT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public MajorVersionConstraintEnum getMajorVersionConstraint() {
        return majorVersionConstraint;
    }

    @JsonProperty(JSON_PROPERTY_MAJOR_VERSION_CONSTRAINT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setMajorVersionConstraint(MajorVersionConstraintEnum majorVersionConstraint) {
        this.majorVersionConstraint = majorVersionConstraint;
    }

    public OSVersionConstraint minimum(String minimum) {

        this.minimum = minimum;
        return this;
    }

    /**
     * The Windows device version must be equal to or newer than the specified version
     *
     * @return minimum
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "12.4.5.9", value = "The Windows device version must be equal to or newer than the specified version")
    @JsonProperty(JSON_PROPERTY_MINIMUM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getMinimum() {
        return minimum;
    }

    @JsonProperty(JSON_PROPERTY_MINIMUM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMinimum(String minimum) {
        this.minimum = minimum;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OSVersionConstraint osVersionConstraint = (OSVersionConstraint) o;
        return Objects.equals(this.dynamicVersionRequirement, osVersionConstraint.dynamicVersionRequirement)
                && Objects.equals(this.majorVersionConstraint, osVersionConstraint.majorVersionConstraint)
                && Objects.equals(this.minimum, osVersionConstraint.minimum);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(dynamicVersionRequirement, majorVersionConstraint, minimum);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OSVersionConstraint {\n");
        sb.append("    dynamicVersionRequirement: ").append(toIndentedString(dynamicVersionRequirement)).append("\n");
        sb.append("    majorVersionConstraint: ").append(toIndentedString(majorVersionConstraint)).append("\n");
        sb.append("    minimum: ").append(toIndentedString(minimum)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
