package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ApplicationSettingsNotes;
import com.okta.sdk.resource.model.ApplicationSettingsNotifications;
import com.okta.sdk.resource.model.OINSaml11ApplicationSettingsSignOn;
import com.okta.sdk.resource.model.Office365ApplicationSettingsApplication;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Office365ApplicationSettings
 */
@JsonPropertyOrder({ Office365ApplicationSettings.JSON_PROPERTY_IDENTITY_STORE_ID,
        Office365ApplicationSettings.JSON_PROPERTY_IMPLICIT_ASSIGNMENT,
        Office365ApplicationSettings.JSON_PROPERTY_INLINE_HOOK_ID, Office365ApplicationSettings.JSON_PROPERTY_NOTES,
        Office365ApplicationSettings.JSON_PROPERTY_NOTIFICATIONS, Office365ApplicationSettings.JSON_PROPERTY_SIGN_ON,
        Office365ApplicationSettings.JSON_PROPERTY_APP })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class Office365ApplicationSettings implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_IDENTITY_STORE_ID = "identityStoreId";
    private String identityStoreId;

    public static final String JSON_PROPERTY_IMPLICIT_ASSIGNMENT = "implicitAssignment";
    private Boolean implicitAssignment;

    public static final String JSON_PROPERTY_INLINE_HOOK_ID = "inlineHookId";
    private String inlineHookId;

    public static final String JSON_PROPERTY_NOTES = "notes";
    private ApplicationSettingsNotes notes;

    public static final String JSON_PROPERTY_NOTIFICATIONS = "notifications";
    private ApplicationSettingsNotifications notifications;

    public static final String JSON_PROPERTY_SIGN_ON = "signOn";
    private OINSaml11ApplicationSettingsSignOn signOn;

    public static final String JSON_PROPERTY_APP = "app";
    private Office365ApplicationSettingsApplication app;

    public Office365ApplicationSettings() {
    }

    public Office365ApplicationSettings identityStoreId(String identityStoreId) {

        this.identityStoreId = identityStoreId;
        return this;
    }

    /**
     * Identifies an additional identity store app, if your app supports it. The &#x60;identityStoreId&#x60; value must
     * be a valid identity store app ID. This identity store app must be created in the same org as your app.
     *
     * @return identityStoreId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Identifies an additional identity store app, if your app supports it. The `identityStoreId` value must be a valid identity store app ID. This identity store app must be created in the same org as your app.")
    @JsonProperty(JSON_PROPERTY_IDENTITY_STORE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getIdentityStoreId() {
        return identityStoreId;
    }

    @JsonProperty(JSON_PROPERTY_IDENTITY_STORE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIdentityStoreId(String identityStoreId) {
        this.identityStoreId = identityStoreId;
    }

    public Office365ApplicationSettings implicitAssignment(Boolean implicitAssignment) {

        this.implicitAssignment = implicitAssignment;
        return this;
    }

    /**
     * Controls whether Okta automatically assigns users to the app based on the user&#39;s role or group membership.
     *
     * @return implicitAssignment
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Controls whether Okta automatically assigns users to the app based on the user's role or group membership.")
    @JsonProperty(JSON_PROPERTY_IMPLICIT_ASSIGNMENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getImplicitAssignment() {
        return implicitAssignment;
    }

    @JsonProperty(JSON_PROPERTY_IMPLICIT_ASSIGNMENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setImplicitAssignment(Boolean implicitAssignment) {
        this.implicitAssignment = implicitAssignment;
    }

    public Office365ApplicationSettings inlineHookId(String inlineHookId) {

        this.inlineHookId = inlineHookId;
        return this;
    }

    /**
     * Identifier of an inline hook. Inline hooks are outbound calls from Okta to your own custom code, triggered at
     * specific points in Okta process flows. They allow you to integrate custom functionality into those flows. See
     * [Inline hooks](/openapi/okta-management/management/tag/InlineHook/).
     *
     * @return inlineHookId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Identifier of an inline hook. Inline hooks are outbound calls from Okta to your own custom code, triggered at specific points in Okta process flows. They allow you to integrate custom functionality into those flows. See [Inline hooks](/openapi/okta-management/management/tag/InlineHook/).")
    @JsonProperty(JSON_PROPERTY_INLINE_HOOK_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getInlineHookId() {
        return inlineHookId;
    }

    @JsonProperty(JSON_PROPERTY_INLINE_HOOK_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setInlineHookId(String inlineHookId) {
        this.inlineHookId = inlineHookId;
    }

    public Office365ApplicationSettings notes(ApplicationSettingsNotes notes) {

        this.notes = notes;
        return this;
    }

    /**
     * Get notes
     *
     * @return notes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_NOTES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationSettingsNotes getNotes() {
        return notes;
    }

    @JsonProperty(JSON_PROPERTY_NOTES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setNotes(ApplicationSettingsNotes notes) {
        this.notes = notes;
    }

    public Office365ApplicationSettings notifications(ApplicationSettingsNotifications notifications) {

        this.notifications = notifications;
        return this;
    }

    /**
     * Get notifications
     *
     * @return notifications
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_NOTIFICATIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationSettingsNotifications getNotifications() {
        return notifications;
    }

    @JsonProperty(JSON_PROPERTY_NOTIFICATIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setNotifications(ApplicationSettingsNotifications notifications) {
        this.notifications = notifications;
    }

    public Office365ApplicationSettings signOn(OINSaml11ApplicationSettingsSignOn signOn) {

        this.signOn = signOn;
        return this;
    }

    /**
     * Get signOn
     *
     * @return signOn
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SIGN_ON)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OINSaml11ApplicationSettingsSignOn getSignOn() {
        return signOn;
    }

    @JsonProperty(JSON_PROPERTY_SIGN_ON)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSignOn(OINSaml11ApplicationSettingsSignOn signOn) {
        this.signOn = signOn;
    }

    public Office365ApplicationSettings app(Office365ApplicationSettingsApplication app) {

        this.app = app;
        return this;
    }

    /**
     * Get app
     *
     * @return app
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_APP)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public Office365ApplicationSettingsApplication getApp() {
        return app;
    }

    @JsonProperty(JSON_PROPERTY_APP)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setApp(Office365ApplicationSettingsApplication app) {
        this.app = app;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Office365ApplicationSettings office365ApplicationSettings = (Office365ApplicationSettings) o;
        return Objects.equals(this.identityStoreId, office365ApplicationSettings.identityStoreId)
                && Objects.equals(this.implicitAssignment, office365ApplicationSettings.implicitAssignment)
                && Objects.equals(this.inlineHookId, office365ApplicationSettings.inlineHookId)
                && Objects.equals(this.notes, office365ApplicationSettings.notes)
                && Objects.equals(this.notifications, office365ApplicationSettings.notifications)
                && Objects.equals(this.signOn, office365ApplicationSettings.signOn)
                && Objects.equals(this.app, office365ApplicationSettings.app);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(identityStoreId, implicitAssignment, inlineHookId, notes, notifications, signOn, app);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Office365ApplicationSettings {\n");
        sb.append("    identityStoreId: ").append(toIndentedString(identityStoreId)).append("\n");
        sb.append("    implicitAssignment: ").append(toIndentedString(implicitAssignment)).append("\n");
        sb.append("    inlineHookId: ").append(toIndentedString(inlineHookId)).append("\n");
        sb.append("    notes: ").append(toIndentedString(notes)).append("\n");
        sb.append("    notifications: ").append(toIndentedString(notifications)).append("\n");
        sb.append("    signOn: ").append(toIndentedString(signOn)).append("\n");
        sb.append("    app: ").append(toIndentedString(app)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
