package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Profile for any Group that is not imported from Active Directory. Specifies the standard and custom profile
 * properties for a Group. The &#x60;objectClass&#x60; for these groups is &#x60;okta:user_group&#x60;.
 */
@ApiModel(description = "Profile for any Group that is not imported from Active Directory. Specifies the standard and custom profile properties for a Group.  The `objectClass` for these groups is `okta:user_group`.")
@JsonPropertyOrder({ OktaUserGroupProfile.JSON_PROPERTY_DESCRIPTION, OktaUserGroupProfile.JSON_PROPERTY_NAME })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OktaUserGroupProfile implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public OktaUserGroupProfile() {
    }

    public OktaUserGroupProfile description(String description) {

        this.description = description;
        return this;
    }

    /**
     * Description of the Group
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "All Users West of The Rockies", value = "Description of the Group")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public OktaUserGroupProfile name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Name of the Group
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "West Coast Users", value = "Name of the Group")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OktaUserGroupProfile oktaUserGroupProfile = (OktaUserGroupProfile) o;
        return Objects.equals(this.description, oktaUserGroupProfile.description)
                && Objects.equals(this.name, oktaUserGroupProfile.name);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(description, name);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OktaUserGroupProfile {\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
