package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * PasswordPolicyDelegationSettingsOptions
 */
@JsonPropertyOrder({ PasswordPolicyDelegationSettingsOptions.JSON_PROPERTY_SKIP_UNLOCK })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class PasswordPolicyDelegationSettingsOptions implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SKIP_UNLOCK = "skipUnlock";
    private Boolean skipUnlock = false;

    public PasswordPolicyDelegationSettingsOptions() {
    }

    public PasswordPolicyDelegationSettingsOptions skipUnlock(Boolean skipUnlock) {

        this.skipUnlock = skipUnlock;
        return this;
    }

    /**
     * Indicates if, when performing an unlock operation on an Active Directory sourced User who is locked out of Okta,
     * the system should also attempt to unlock the User&#39;s Windows account
     *
     * @return skipUnlock
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if, when performing an unlock operation on an Active Directory sourced User who is locked out of Okta, the system should also attempt to unlock the User's Windows account")
    @JsonProperty(JSON_PROPERTY_SKIP_UNLOCK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getSkipUnlock() {
        return skipUnlock;
    }

    @JsonProperty(JSON_PROPERTY_SKIP_UNLOCK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSkipUnlock(Boolean skipUnlock) {
        this.skipUnlock = skipUnlock;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PasswordPolicyDelegationSettingsOptions passwordPolicyDelegationSettingsOptions = (PasswordPolicyDelegationSettingsOptions) o;
        return Objects.equals(this.skipUnlock, passwordPolicyDelegationSettingsOptions.skipUnlock);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(skipUnlock);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PasswordPolicyDelegationSettingsOptions {\n");
        sb.append("    skipUnlock: ").append(toIndentedString(skipUnlock)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
