package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Pin Request
 */
@ApiModel(description = "Pin Request")
@JsonPropertyOrder({ PinRequest.JSON_PROPERTY_AUTHENTICATOR_ENROLLMENT_ID,
        PinRequest.JSON_PROPERTY_FULFILLMENT_PROVIDER, PinRequest.JSON_PROPERTY_USER_ID })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class PinRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUTHENTICATOR_ENROLLMENT_ID = "authenticatorEnrollmentId";
    private String authenticatorEnrollmentId;

    /**
     * Name of the fulfillment provider for the WebAuthn Preregistration Factor
     */
    public enum FulfillmentProviderEnum {
        YUBICO("yubico"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        FulfillmentProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static FulfillmentProviderEnum fromValue(String value) {
            for (FulfillmentProviderEnum b : FulfillmentProviderEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_FULFILLMENT_PROVIDER = "fulfillmentProvider";
    private FulfillmentProviderEnum fulfillmentProvider;

    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;

    public PinRequest() {
    }

    public PinRequest authenticatorEnrollmentId(String authenticatorEnrollmentId) {

        this.authenticatorEnrollmentId = authenticatorEnrollmentId;
        return this;
    }

    /**
     * ID for a WebAuthn Preregistration Factor in Okta
     *
     * @return authenticatorEnrollmentId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ID for a WebAuthn Preregistration Factor in Okta")
    @JsonProperty(JSON_PROPERTY_AUTHENTICATOR_ENROLLMENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAuthenticatorEnrollmentId() {
        return authenticatorEnrollmentId;
    }

    @JsonProperty(JSON_PROPERTY_AUTHENTICATOR_ENROLLMENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticatorEnrollmentId(String authenticatorEnrollmentId) {
        this.authenticatorEnrollmentId = authenticatorEnrollmentId;
    }

    public PinRequest fulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {

        this.fulfillmentProvider = fulfillmentProvider;
        return this;
    }

    /**
     * Name of the fulfillment provider for the WebAuthn Preregistration Factor
     *
     * @return fulfillmentProvider
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the fulfillment provider for the WebAuthn Preregistration Factor")
    @JsonProperty(JSON_PROPERTY_FULFILLMENT_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public FulfillmentProviderEnum getFulfillmentProvider() {
        return fulfillmentProvider;
    }

    @JsonProperty(JSON_PROPERTY_FULFILLMENT_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {
        this.fulfillmentProvider = fulfillmentProvider;
    }

    public PinRequest userId(String userId) {

        this.userId = userId;
        return this;
    }

    /**
     * ID of an existing Okta user
     *
     * @return userId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ID of an existing Okta user")
    @JsonProperty(JSON_PROPERTY_USER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUserId() {
        return userId;
    }

    @JsonProperty(JSON_PROPERTY_USER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PinRequest pinRequest = (PinRequest) o;
        return Objects.equals(this.authenticatorEnrollmentId, pinRequest.authenticatorEnrollmentId)
                && Objects.equals(this.fulfillmentProvider, pinRequest.fulfillmentProvider)
                && Objects.equals(this.userId, pinRequest.userId);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(authenticatorEnrollmentId, fulfillmentProvider, userId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PinRequest {\n");
        sb.append("    authenticatorEnrollmentId: ").append(toIndentedString(authenticatorEnrollmentId)).append("\n");
        sb.append("    fulfillmentProvider: ").append(toIndentedString(fulfillmentProvider)).append("\n");
        sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
