package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * PostAPIServiceIntegrationInstanceRequest
 */
@JsonPropertyOrder({ PostAPIServiceIntegrationInstanceRequest.JSON_PROPERTY_GRANTED_SCOPES,
        PostAPIServiceIntegrationInstanceRequest.JSON_PROPERTY_TYPE })
@JsonTypeName("postAPIServiceIntegrationInstanceRequest")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class PostAPIServiceIntegrationInstanceRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_GRANTED_SCOPES = "grantedScopes";
    private List<String> grantedScopes = new ArrayList<>();

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public PostAPIServiceIntegrationInstanceRequest() {
    }

    public PostAPIServiceIntegrationInstanceRequest grantedScopes(List<String> grantedScopes) {

        this.grantedScopes = grantedScopes;
        return this;
    }

    public PostAPIServiceIntegrationInstanceRequest addgrantedScopesItem(String grantedScopesItem) {
        if (this.grantedScopes == null) {
            this.grantedScopes = new ArrayList<>();
        }
        this.grantedScopes.add(grantedScopesItem);
        return this;
    }

    /**
     * The list of Okta management scopes granted to the API Service Integration instance. See [Okta management OAuth
     * 2.0 scopes](/oauth2/#okta-admin-management).
     *
     * @return grantedScopes
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "[\"okta.logs.read\"]", required = true, value = "The list of Okta management scopes granted to the API Service Integration instance. See [Okta management OAuth 2.0 scopes](/oauth2/#okta-admin-management).")
    @JsonProperty(JSON_PROPERTY_GRANTED_SCOPES)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public List<String> getGrantedScopes() {
        return grantedScopes;
    }

    @JsonProperty(JSON_PROPERTY_GRANTED_SCOPES)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setGrantedScopes(List<String> grantedScopes) {
        this.grantedScopes = grantedScopes;
    }

    public PostAPIServiceIntegrationInstanceRequest type(String type) {

        this.type = type;
        return this;
    }

    /**
     * The type of the API service integration. This string is an underscore-concatenated, lowercased API service
     * integration name. For example, &#x60;my_api_log_integration&#x60;.
     *
     * @return type
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "my_app_cie", required = true, value = "The type of the API service integration. This string is an underscore-concatenated, lowercased API service integration name. For example, `my_api_log_integration`.")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PostAPIServiceIntegrationInstanceRequest postAPIServiceIntegrationInstanceRequest = (PostAPIServiceIntegrationInstanceRequest) o;
        return Objects.equals(this.grantedScopes, postAPIServiceIntegrationInstanceRequest.grantedScopes)
                && Objects.equals(this.type, postAPIServiceIntegrationInstanceRequest.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(grantedScopes, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostAPIServiceIntegrationInstanceRequest {\n");
        sb.append("    grantedScopes: ").append(toIndentedString(grantedScopes)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
