package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LifecycleStatus;
import com.okta.sdk.resource.model.Policy;
import com.okta.sdk.resource.model.PolicyLinks;
import com.okta.sdk.resource.model.PolicyType;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * PostAuthSessionPolicy
 */
@JsonPropertyOrder({ PostAuthSessionPolicy.JSON_PROPERTY_CONDITIONS })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "type", visible = true, defaultImpl = PostAuthSessionPolicy.class)

public class PostAuthSessionPolicy extends Policy implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private JsonNullable<String> conditions = JsonNullable.<String> undefined();

    public PostAuthSessionPolicy() {
    }

    /*
     * @JsonCreator public PostAuthSessionPolicy(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_EMBEDDED) Map<String, Object> embedded ) { this(); this.created = created; this.id =
     * id; this.lastUpdated = lastUpdated; this.embedded = embedded; }
     */

    public PostAuthSessionPolicy conditions(String conditions) {
        this.conditions = JsonNullable.<String> of(conditions);

        return this;
    }

    /**
     * Policy conditions aren&#39;t supported for this policy type.
     *
     * @return conditions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Policy conditions aren't supported for this policy type.")
    @JsonIgnore

    public String getConditions() {
        return conditions.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getConditions_JsonNullable() {
        return conditions;
    }

    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    public void setConditions_JsonNullable(JsonNullable<String> conditions) {
        this.conditions = conditions;
    }

    public void setConditions(String conditions) {
        this.conditions = JsonNullable.<String> of(conditions);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PostAuthSessionPolicy postAuthSessionPolicy = (PostAuthSessionPolicy) o;
        return equalsNullable(this.conditions, postAuthSessionPolicy.conditions);
        // && super.equals(o);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b
                || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(hashCodeNullable(conditions), super.hashCode());
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[] { a.get() }) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostAuthSessionPolicy {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
