package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.PrivilegedAccountCredentials;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Details for managing an Okta Universal Directory Account as a Privileged Account
 */
@ApiModel(description = "Details for managing an Okta Universal Directory Account as a Privileged Account")
@JsonPropertyOrder({ PrivilegedAccountDetailsOktaUserAccountSub.JSON_PROPERTY_CREDENTIALS,
        PrivilegedAccountDetailsOktaUserAccountSub.JSON_PROPERTY_EMAIL,
        PrivilegedAccountDetailsOktaUserAccountSub.JSON_PROPERTY_OKTA_USER_ID })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class PrivilegedAccountDetailsOktaUserAccountSub implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private PrivilegedAccountCredentials credentials;

    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;

    public static final String JSON_PROPERTY_OKTA_USER_ID = "oktaUserId";
    private String oktaUserId;

    public PrivilegedAccountDetailsOktaUserAccountSub() {
    }

    public PrivilegedAccountDetailsOktaUserAccountSub credentials(PrivilegedAccountCredentials credentials) {

        this.credentials = credentials;
        return this;
    }

    /**
     * Get credentials
     *
     * @return credentials
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public PrivilegedAccountCredentials getCredentials() {
        return credentials;
    }

    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setCredentials(PrivilegedAccountCredentials credentials) {
        this.credentials = credentials;
    }

    public PrivilegedAccountDetailsOktaUserAccountSub email(String email) {

        this.email = email;
        return this;
    }

    /**
     * The email address for the Okta Universal Directory Account
     *
     * @return email
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "foo@bar.com", required = true, value = "The email address for the Okta Universal Directory Account")
    @JsonProperty(JSON_PROPERTY_EMAIL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getEmail() {
        return email;
    }

    @JsonProperty(JSON_PROPERTY_EMAIL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setEmail(String email) {
        this.email = email;
    }

    public PrivilegedAccountDetailsOktaUserAccountSub oktaUserId(String oktaUserId) {

        this.oktaUserId = oktaUserId;
        return this;
    }

    /**
     * An optional Okta user ID. If supplied, converts the matching Okta Universal Directory Account to a Privileged
     * Account and updates the account with the provided details.
     *
     * @return oktaUserId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "00u11s48P9zGW8yqm0g5", value = "An optional Okta user ID. If supplied, converts the matching Okta Universal Directory Account to a Privileged Account and updates the account with the provided details.")
    @JsonProperty(JSON_PROPERTY_OKTA_USER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOktaUserId() {
        return oktaUserId;
    }

    @JsonProperty(JSON_PROPERTY_OKTA_USER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOktaUserId(String oktaUserId) {
        this.oktaUserId = oktaUserId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PrivilegedAccountDetailsOktaUserAccountSub privilegedAccountDetailsOktaUserAccountSub = (PrivilegedAccountDetailsOktaUserAccountSub) o;
        return Objects.equals(this.credentials, privilegedAccountDetailsOktaUserAccountSub.credentials)
                && Objects.equals(this.email, privilegedAccountDetailsOktaUserAccountSub.email)
                && Objects.equals(this.oktaUserId, privilegedAccountDetailsOktaUserAccountSub.oktaUserId);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(credentials, email, oktaUserId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrivilegedAccountDetailsOktaUserAccountSub {\n");
        sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
        sb.append("    email: ").append(toIndentedString(email)).append("\n");
        sb.append("    oktaUserId: ").append(toIndentedString(oktaUserId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
