package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AppAccountContainerDetails;
import com.okta.sdk.resource.model.CredentialSyncInfo;
import com.okta.sdk.resource.model.PrivilegedResource;
import com.okta.sdk.resource.model.PrivilegedResourceCredentials;
import com.okta.sdk.resource.model.PrivilegedResourceStatus;
import com.okta.sdk.resource.model.PrivilegedResourceType;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * PrivilegedResourceAccountApp
 */
@JsonPropertyOrder({ PrivilegedResourceAccountApp.JSON_PROPERTY_CONTAINER_DETAILS,
        PrivilegedResourceAccountApp.JSON_PROPERTY_CREDENTIALS })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "resourceType", visible = true, defaultImpl = PrivilegedResourceAccountApp.class)

public class PrivilegedResourceAccountApp extends PrivilegedResource implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CONTAINER_DETAILS = "containerDetails";
    private AppAccountContainerDetails containerDetails;

    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private PrivilegedResourceCredentials credentials;

    public PrivilegedResourceAccountApp() {
    }

    /*
     * @JsonCreator public PrivilegedResourceAccountApp(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.created = created; this.id
     * = id; this.lastUpdated = lastUpdated; }
     */

    public PrivilegedResourceAccountApp containerDetails(AppAccountContainerDetails containerDetails) {

        this.containerDetails = containerDetails;
        return this;
    }

    /**
     * Get containerDetails
     *
     * @return containerDetails
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CONTAINER_DETAILS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AppAccountContainerDetails getContainerDetails() {
        return containerDetails;
    }

    @JsonProperty(JSON_PROPERTY_CONTAINER_DETAILS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setContainerDetails(AppAccountContainerDetails containerDetails) {
        this.containerDetails = containerDetails;
    }

    public PrivilegedResourceAccountApp credentials(PrivilegedResourceCredentials credentials) {

        this.credentials = credentials;
        return this;
    }

    /**
     * Get credentials
     *
     * @return credentials
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PrivilegedResourceCredentials getCredentials() {
        return credentials;
    }

    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(PrivilegedResourceCredentials credentials) {
        this.credentials = credentials;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PrivilegedResourceAccountApp privilegedResourceAccountApp = (PrivilegedResourceAccountApp) o;
        return Objects.equals(this.containerDetails, privilegedResourceAccountApp.containerDetails)
                && Objects.equals(this.credentials, privilegedResourceAccountApp.credentials);
        // && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(containerDetails, credentials, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrivilegedResourceAccountApp {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    containerDetails: ").append(toIndentedString(containerDetails)).append("\n");
        sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
