package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
*
*/
@ApiModel(description = "")
@JsonPropertyOrder({ RateLimitWarningThresholdRequest.JSON_PROPERTY_WARNING_THRESHOLD })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class RateLimitWarningThresholdRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_WARNING_THRESHOLD = "warningThreshold";
    private Integer warningThreshold;

    public RateLimitWarningThresholdRequest() {
    }

    public RateLimitWarningThresholdRequest warningThreshold(Integer warningThreshold) {

        this.warningThreshold = warningThreshold;
        return this;
    }

    /**
     * The threshold value (percentage) of a rate limit that, when exceeded, triggers a warning notification. By
     * default, this value is 90 for Workforce orgs and 60 for CIAM orgs. minimum: 30 maximum: 90
     *
     * @return warningThreshold
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "The threshold value (percentage) of a rate limit that, when exceeded, triggers a warning notification. By default, this value is 90 for Workforce orgs and 60 for CIAM orgs.")
    @JsonProperty(JSON_PROPERTY_WARNING_THRESHOLD)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public Integer getWarningThreshold() {
        return warningThreshold;
    }

    @JsonProperty(JSON_PROPERTY_WARNING_THRESHOLD)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setWarningThreshold(Integer warningThreshold) {
        this.warningThreshold = warningThreshold;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RateLimitWarningThresholdRequest rateLimitWarningThresholdRequest = (RateLimitWarningThresholdRequest) o;
        return Objects.equals(this.warningThreshold, rateLimitWarningThresholdRequest.warningThreshold);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(warningThreshold);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RateLimitWarningThresholdRequest {\n");
        sb.append("    warningThreshold: ").append(toIndentedString(warningThreshold)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
