package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * RealmProfile
 */
@JsonPropertyOrder({ RealmProfile.JSON_PROPERTY_NAME, RealmProfile.JSON_PROPERTY_REALM_TYPE })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class RealmProfile implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    /**
     * Used to store partner users. This must be set to Partner to access Okta&#39;s external partner portal.
     */
    public enum RealmTypeEnum {
        PARTNER("PARTNER"),

        DEFAULT("DEFAULT"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        RealmTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static RealmTypeEnum fromValue(String value) {
            for (RealmTypeEnum b : RealmTypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_REALM_TYPE = "realmType";
    private RealmTypeEnum realmType;

    public RealmProfile() {
    }

    public RealmProfile name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Name of a Realm
     *
     * @return name
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Name of a Realm")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public RealmProfile realmType(RealmTypeEnum realmType) {

        this.realmType = realmType;
        return this;
    }

    /**
     * Used to store partner users. This must be set to Partner to access Okta&#39;s external partner portal.
     *
     * @return realmType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Used to store partner users. This must be set to Partner to access Okta's external partner portal.")
    @JsonProperty(JSON_PROPERTY_REALM_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public RealmTypeEnum getRealmType() {
        return realmType;
    }

    @JsonProperty(JSON_PROPERTY_REALM_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRealmType(RealmTypeEnum realmType) {
        this.realmType = realmType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RealmProfile realmProfile = (RealmProfile) o;
        return Objects.equals(this.name, realmProfile.name) && Objects.equals(this.realmType, realmProfile.realmType);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, realmType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RealmProfile {\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    realmType: ").append(toIndentedString(realmType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
