package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LinksGovernanceSources;
import com.okta.sdk.resource.model.RoleGovernanceSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * List of all User Role Governance Sources
 */
@ApiModel(description = "List of all User Role Governance Sources")
@JsonPropertyOrder({ RoleGovernance.JSON_PROPERTY_GRANTS, RoleGovernance.JSON_PROPERTY_LINKS })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class RoleGovernance implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_GRANTS = "grants";
    private List<RoleGovernanceSource> grants = null;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksGovernanceSources links;

    public RoleGovernance() {
    }

    public RoleGovernance grants(List<RoleGovernanceSource> grants) {

        this.grants = grants;
        return this;
    }

    public RoleGovernance addgrantsItem(RoleGovernanceSource grantsItem) {
        if (this.grants == null) {
            this.grants = new ArrayList<>();
        }
        this.grants.add(grantsItem);
        return this;
    }

    /**
     * Get grants
     *
     * @return grants
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_GRANTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<RoleGovernanceSource> getGrants() {
        return grants;
    }

    @JsonProperty(JSON_PROPERTY_GRANTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGrants(List<RoleGovernanceSource> grants) {
        this.grants = grants;
    }

    public RoleGovernance links(LinksGovernanceSources links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksGovernanceSources getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksGovernanceSources links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RoleGovernance roleGovernance = (RoleGovernance) o;
        return Objects.equals(this.grants, roleGovernance.grants) && Objects.equals(this.links, roleGovernance.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(grants, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoleGovernance {\n");
        sb.append("    grants: ").append(toIndentedString(grants)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
