package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Salesforce app instance properties
 */
@ApiModel(description = "Salesforce app instance properties")
@JsonPropertyOrder({ SalesforceApplicationSettingsApplication.JSON_PROPERTY_INSTANCE_TYPE,
        SalesforceApplicationSettingsApplication.JSON_PROPERTY_INTEGRATION_TYPE,
        SalesforceApplicationSettingsApplication.JSON_PROPERTY_LOGIN_URL,
        SalesforceApplicationSettingsApplication.JSON_PROPERTY_LOGOUT_URL })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SalesforceApplicationSettingsApplication implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Salesforce instance that you want to connect to
     */
    public enum InstanceTypeEnum {
        SANDBOX("SANDBOX"),

        PRODUCTION("PRODUCTION"),

        GOVERNMENT("GOVERNMENT"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        InstanceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static InstanceTypeEnum fromValue(String value) {
            for (InstanceTypeEnum b : InstanceTypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_INSTANCE_TYPE = "instanceType";
    private InstanceTypeEnum instanceType;

    /**
     * Salesforce integration type
     */
    public enum IntegrationTypeEnum {
        STANDARD("STANDARD"),

        PORTAL("PORTAL"),

        COMMUNITY("COMMUNITY"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        IntegrationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static IntegrationTypeEnum fromValue(String value) {
            for (IntegrationTypeEnum b : IntegrationTypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_INTEGRATION_TYPE = "integrationType";
    private IntegrationTypeEnum integrationType;

    public static final String JSON_PROPERTY_LOGIN_URL = "loginUrl";
    private String loginUrl;

    public static final String JSON_PROPERTY_LOGOUT_URL = "logoutUrl";
    private String logoutUrl;

    public SalesforceApplicationSettingsApplication() {
    }

    public SalesforceApplicationSettingsApplication instanceType(InstanceTypeEnum instanceType) {

        this.instanceType = instanceType;
        return this;
    }

    /**
     * Salesforce instance that you want to connect to
     *
     * @return instanceType
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Salesforce instance that you want to connect to")
    @JsonProperty(JSON_PROPERTY_INSTANCE_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public InstanceTypeEnum getInstanceType() {
        return instanceType;
    }

    @JsonProperty(JSON_PROPERTY_INSTANCE_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setInstanceType(InstanceTypeEnum instanceType) {
        this.instanceType = instanceType;
    }

    public SalesforceApplicationSettingsApplication integrationType(IntegrationTypeEnum integrationType) {

        this.integrationType = integrationType;
        return this;
    }

    /**
     * Salesforce integration type
     *
     * @return integrationType
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Salesforce integration type")
    @JsonProperty(JSON_PROPERTY_INTEGRATION_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public IntegrationTypeEnum getIntegrationType() {
        return integrationType;
    }

    @JsonProperty(JSON_PROPERTY_INTEGRATION_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setIntegrationType(IntegrationTypeEnum integrationType) {
        this.integrationType = integrationType;
    }

    public SalesforceApplicationSettingsApplication loginUrl(String loginUrl) {

        this.loginUrl = loginUrl;
        return this;
    }

    /**
     * The Login URL specified in your Salesforce Single Sign-On settings
     *
     * @return loginUrl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The Login URL specified in your Salesforce Single Sign-On settings")
    @JsonProperty(JSON_PROPERTY_LOGIN_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLoginUrl() {
        return loginUrl;
    }

    @JsonProperty(JSON_PROPERTY_LOGIN_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public SalesforceApplicationSettingsApplication logoutUrl(String logoutUrl) {

        this.logoutUrl = logoutUrl;
        return this;
    }

    /**
     * Salesforce Logout URL
     *
     * @return logoutUrl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Salesforce Logout URL")
    @JsonProperty(JSON_PROPERTY_LOGOUT_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLogoutUrl() {
        return logoutUrl;
    }

    @JsonProperty(JSON_PROPERTY_LOGOUT_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SalesforceApplicationSettingsApplication salesforceApplicationSettingsApplication = (SalesforceApplicationSettingsApplication) o;
        return Objects.equals(this.instanceType, salesforceApplicationSettingsApplication.instanceType)
                && Objects.equals(this.integrationType, salesforceApplicationSettingsApplication.integrationType)
                && Objects.equals(this.loginUrl, salesforceApplicationSettingsApplication.loginUrl)
                && Objects.equals(this.logoutUrl, salesforceApplicationSettingsApplication.logoutUrl);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(instanceType, integrationType, loginUrl, logoutUrl);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SalesforceApplicationSettingsApplication {\n");
        sb.append("    instanceType: ").append(toIndentedString(instanceType)).append("\n");
        sb.append("    integrationType: ").append(toIndentedString(integrationType)).append("\n");
        sb.append("    loginUrl: ").append(toIndentedString(loginUrl)).append("\n");
        sb.append("    logoutUrl: ").append(toIndentedString(logoutUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
