package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ProtocolAlgorithmResponseScope;
import com.okta.sdk.resource.model.SamlSigningAlgorithm;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * XML digital Signature Algorithm settings for verifying &#x60;&lt;SAMLResponse&gt;&#x60; messages and
 * &#x60;&lt;Assertion&gt;&#x60; elements from the IdP
 */
@ApiModel(description = "XML digital Signature Algorithm settings for verifying `<SAMLResponse>` messages and `<Assertion>` elements from the IdP")
@JsonPropertyOrder({ SamlResponseSignatureAlgorithm.JSON_PROPERTY_ALGORITHM,
        SamlResponseSignatureAlgorithm.JSON_PROPERTY_SCOPE })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SamlResponseSignatureAlgorithm implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ALGORITHM = "algorithm";
    private SamlSigningAlgorithm algorithm;

    public static final String JSON_PROPERTY_SCOPE = "scope";
    private ProtocolAlgorithmResponseScope scope;

    public SamlResponseSignatureAlgorithm() {
    }

    public SamlResponseSignatureAlgorithm algorithm(SamlSigningAlgorithm algorithm) {

        this.algorithm = algorithm;
        return this;
    }

    /**
     * Get algorithm
     *
     * @return algorithm
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ALGORITHM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SamlSigningAlgorithm getAlgorithm() {
        return algorithm;
    }

    @JsonProperty(JSON_PROPERTY_ALGORITHM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAlgorithm(SamlSigningAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public SamlResponseSignatureAlgorithm scope(ProtocolAlgorithmResponseScope scope) {

        this.scope = scope;
        return this;
    }

    /**
     * Get scope
     *
     * @return scope
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SCOPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProtocolAlgorithmResponseScope getScope() {
        return scope;
    }

    @JsonProperty(JSON_PROPERTY_SCOPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScope(ProtocolAlgorithmResponseScope scope) {
        this.scope = scope;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SamlResponseSignatureAlgorithm samlResponseSignatureAlgorithm = (SamlResponseSignatureAlgorithm) o;
        return Objects.equals(this.algorithm, samlResponseSignatureAlgorithm.algorithm)
                && Objects.equals(this.scope, samlResponseSignatureAlgorithm.scope);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(algorithm, scope);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlResponseSignatureAlgorithm {\n");
        sb.append("    algorithm: ").append(toIndentedString(algorithm)).append("\n");
        sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
