package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Key used for signing requests to the IdP
 */
@ApiModel(description = "Key used for signing requests to the IdP")
@JsonPropertyOrder({ SamlSigningCredentials.JSON_PROPERTY_KID })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SamlSigningCredentials implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;

    public SamlSigningCredentials() {
    }

    public SamlSigningCredentials kid(String kid) {

        this.kid = kid;
        return this;
    }

    /**
     * IdP Key Credential reference to the Okta X.509 signature certificate
     *
     * @return kid
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "your-key-id", value = "IdP Key Credential reference to the Okta X.509 signature certificate")
    @JsonProperty(JSON_PROPERTY_KID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getKid() {
        return kid;
    }

    @JsonProperty(JSON_PROPERTY_KID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setKid(String kid) {
        this.kid = kid;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SamlSigningCredentials samlSigningCredentials = (SamlSigningCredentials) o;
        return Objects.equals(this.kid, samlSigningCredentials.kid);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(kid);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlSigningCredentials {\n");
        sb.append("    kid: ").append(toIndentedString(kid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
