package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * SecurePasswordStoreApplicationSettingsApplication
 */
@JsonPropertyOrder({ SecurePasswordStoreApplicationSettingsApplication.JSON_PROPERTY_OPTIONAL_FIELD1,
        SecurePasswordStoreApplicationSettingsApplication.JSON_PROPERTY_OPTIONAL_FIELD1_VALUE,
        SecurePasswordStoreApplicationSettingsApplication.JSON_PROPERTY_OPTIONAL_FIELD2,
        SecurePasswordStoreApplicationSettingsApplication.JSON_PROPERTY_OPTIONAL_FIELD2_VALUE,
        SecurePasswordStoreApplicationSettingsApplication.JSON_PROPERTY_OPTIONAL_FIELD3,
        SecurePasswordStoreApplicationSettingsApplication.JSON_PROPERTY_OPTIONAL_FIELD3_VALUE,
        SecurePasswordStoreApplicationSettingsApplication.JSON_PROPERTY_PASSWORD_FIELD,
        SecurePasswordStoreApplicationSettingsApplication.JSON_PROPERTY_URL,
        SecurePasswordStoreApplicationSettingsApplication.JSON_PROPERTY_USERNAME_FIELD })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SecurePasswordStoreApplicationSettingsApplication implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_OPTIONAL_FIELD1 = "optionalField1";
    private String optionalField1;

    public static final String JSON_PROPERTY_OPTIONAL_FIELD1_VALUE = "optionalField1Value";
    private String optionalField1Value;

    public static final String JSON_PROPERTY_OPTIONAL_FIELD2 = "optionalField2";
    private String optionalField2;

    public static final String JSON_PROPERTY_OPTIONAL_FIELD2_VALUE = "optionalField2Value";
    private String optionalField2Value;

    public static final String JSON_PROPERTY_OPTIONAL_FIELD3 = "optionalField3";
    private String optionalField3;

    public static final String JSON_PROPERTY_OPTIONAL_FIELD3_VALUE = "optionalField3Value";
    private String optionalField3Value;

    public static final String JSON_PROPERTY_PASSWORD_FIELD = "passwordField";
    private String passwordField;

    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public static final String JSON_PROPERTY_USERNAME_FIELD = "usernameField";
    private String usernameField;

    public SecurePasswordStoreApplicationSettingsApplication() {
    }

    public SecurePasswordStoreApplicationSettingsApplication optionalField1(String optionalField1) {

        this.optionalField1 = optionalField1;
        return this;
    }

    /**
     * Name of the optional parameter in the sign-in form
     *
     * @return optionalField1
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the optional parameter in the sign-in form")
    @JsonProperty(JSON_PROPERTY_OPTIONAL_FIELD1)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOptionalField1() {
        return optionalField1;
    }

    @JsonProperty(JSON_PROPERTY_OPTIONAL_FIELD1)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOptionalField1(String optionalField1) {
        this.optionalField1 = optionalField1;
    }

    public SecurePasswordStoreApplicationSettingsApplication optionalField1Value(String optionalField1Value) {

        this.optionalField1Value = optionalField1Value;
        return this;
    }

    /**
     * Name of the optional value in the sign-in form
     *
     * @return optionalField1Value
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the optional value in the sign-in form")
    @JsonProperty(JSON_PROPERTY_OPTIONAL_FIELD1_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOptionalField1Value() {
        return optionalField1Value;
    }

    @JsonProperty(JSON_PROPERTY_OPTIONAL_FIELD1_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOptionalField1Value(String optionalField1Value) {
        this.optionalField1Value = optionalField1Value;
    }

    public SecurePasswordStoreApplicationSettingsApplication optionalField2(String optionalField2) {

        this.optionalField2 = optionalField2;
        return this;
    }

    /**
     * Name of the optional parameter in the sign-in form
     *
     * @return optionalField2
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the optional parameter in the sign-in form")
    @JsonProperty(JSON_PROPERTY_OPTIONAL_FIELD2)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOptionalField2() {
        return optionalField2;
    }

    @JsonProperty(JSON_PROPERTY_OPTIONAL_FIELD2)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOptionalField2(String optionalField2) {
        this.optionalField2 = optionalField2;
    }

    public SecurePasswordStoreApplicationSettingsApplication optionalField2Value(String optionalField2Value) {

        this.optionalField2Value = optionalField2Value;
        return this;
    }

    /**
     * Name of the optional value in the sign-in form
     *
     * @return optionalField2Value
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the optional value in the sign-in form")
    @JsonProperty(JSON_PROPERTY_OPTIONAL_FIELD2_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOptionalField2Value() {
        return optionalField2Value;
    }

    @JsonProperty(JSON_PROPERTY_OPTIONAL_FIELD2_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOptionalField2Value(String optionalField2Value) {
        this.optionalField2Value = optionalField2Value;
    }

    public SecurePasswordStoreApplicationSettingsApplication optionalField3(String optionalField3) {

        this.optionalField3 = optionalField3;
        return this;
    }

    /**
     * Name of the optional parameter in the sign-in form
     *
     * @return optionalField3
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the optional parameter in the sign-in form")
    @JsonProperty(JSON_PROPERTY_OPTIONAL_FIELD3)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOptionalField3() {
        return optionalField3;
    }

    @JsonProperty(JSON_PROPERTY_OPTIONAL_FIELD3)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOptionalField3(String optionalField3) {
        this.optionalField3 = optionalField3;
    }

    public SecurePasswordStoreApplicationSettingsApplication optionalField3Value(String optionalField3Value) {

        this.optionalField3Value = optionalField3Value;
        return this;
    }

    /**
     * Name of the optional value in the sign-in form
     *
     * @return optionalField3Value
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the optional value in the sign-in form")
    @JsonProperty(JSON_PROPERTY_OPTIONAL_FIELD3_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOptionalField3Value() {
        return optionalField3Value;
    }

    @JsonProperty(JSON_PROPERTY_OPTIONAL_FIELD3_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOptionalField3Value(String optionalField3Value) {
        this.optionalField3Value = optionalField3Value;
    }

    public SecurePasswordStoreApplicationSettingsApplication passwordField(String passwordField) {

        this.passwordField = passwordField;
        return this;
    }

    /**
     * CSS selector for the **Password** field in the sign-in form
     *
     * @return passwordField
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "CSS selector for the **Password** field in the sign-in form")
    @JsonProperty(JSON_PROPERTY_PASSWORD_FIELD)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getPasswordField() {
        return passwordField;
    }

    @JsonProperty(JSON_PROPERTY_PASSWORD_FIELD)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setPasswordField(String passwordField) {
        this.passwordField = passwordField;
    }

    public SecurePasswordStoreApplicationSettingsApplication url(String url) {

        this.url = url;
        return this;
    }

    /**
     * The URL of the sign-in page for this app
     *
     * @return url
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "The URL of the sign-in page for this app")
    @JsonProperty(JSON_PROPERTY_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getUrl() {
        return url;
    }

    @JsonProperty(JSON_PROPERTY_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setUrl(String url) {
        this.url = url;
    }

    public SecurePasswordStoreApplicationSettingsApplication usernameField(String usernameField) {

        this.usernameField = usernameField;
        return this;
    }

    /**
     * CSS selector for the **Username** field in the sign-in form
     *
     * @return usernameField
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "CSS selector for the **Username** field in the sign-in form")
    @JsonProperty(JSON_PROPERTY_USERNAME_FIELD)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getUsernameField() {
        return usernameField;
    }

    @JsonProperty(JSON_PROPERTY_USERNAME_FIELD)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setUsernameField(String usernameField) {
        this.usernameField = usernameField;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SecurePasswordStoreApplicationSettingsApplication securePasswordStoreApplicationSettingsApplication = (SecurePasswordStoreApplicationSettingsApplication) o;
        return Objects.equals(this.optionalField1, securePasswordStoreApplicationSettingsApplication.optionalField1)
                && Objects.equals(this.optionalField1Value,
                        securePasswordStoreApplicationSettingsApplication.optionalField1Value)
                && Objects.equals(this.optionalField2, securePasswordStoreApplicationSettingsApplication.optionalField2)
                && Objects.equals(this.optionalField2Value,
                        securePasswordStoreApplicationSettingsApplication.optionalField2Value)
                && Objects.equals(this.optionalField3, securePasswordStoreApplicationSettingsApplication.optionalField3)
                && Objects.equals(this.optionalField3Value,
                        securePasswordStoreApplicationSettingsApplication.optionalField3Value)
                && Objects.equals(this.passwordField, securePasswordStoreApplicationSettingsApplication.passwordField)
                && Objects.equals(this.url, securePasswordStoreApplicationSettingsApplication.url)
                && Objects.equals(this.usernameField, securePasswordStoreApplicationSettingsApplication.usernameField);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(optionalField1, optionalField1Value, optionalField2, optionalField2Value, optionalField3,
                optionalField3Value, passwordField, url, usernameField);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurePasswordStoreApplicationSettingsApplication {\n");
        sb.append("    optionalField1: ").append(toIndentedString(optionalField1)).append("\n");
        sb.append("    optionalField1Value: ").append(toIndentedString(optionalField1Value)).append("\n");
        sb.append("    optionalField2: ").append(toIndentedString(optionalField2)).append("\n");
        sb.append("    optionalField2Value: ").append(toIndentedString(optionalField2Value)).append("\n");
        sb.append("    optionalField3: ").append(toIndentedString(optionalField3)).append("\n");
        sb.append("    optionalField3Value: ").append(toIndentedString(optionalField3Value)).append("\n");
        sb.append("    passwordField: ").append(toIndentedString(passwordField)).append("\n");
        sb.append("    url: ").append(toIndentedString(url)).append("\n");
        sb.append("    usernameField: ").append(toIndentedString(usernameField)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
