package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SecurityEventSubject;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * SecurityEvent
 */
@JsonPropertyOrder({ SecurityEvent.JSON_PROPERTY_EVENT_TIMESTAMP, SecurityEvent.JSON_PROPERTY_SUBJECT })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SecurityEvent implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EVENT_TIMESTAMP = "event_timestamp";
    private Long eventTimestamp;

    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private SecurityEventSubject subject;

    public SecurityEvent() {
    }

    public SecurityEvent eventTimestamp(Long eventTimestamp) {

        this.eventTimestamp = eventTimestamp;
        return this;
    }

    /**
     * The time of the event (UNIX timestamp)
     *
     * @return eventTimestamp
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "1702448550", required = true, value = "The time of the event (UNIX timestamp)")
    @JsonProperty(JSON_PROPERTY_EVENT_TIMESTAMP)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public Long getEventTimestamp() {
        return eventTimestamp;
    }

    @JsonProperty(JSON_PROPERTY_EVENT_TIMESTAMP)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setEventTimestamp(Long eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
    }

    public SecurityEvent subject(SecurityEventSubject subject) {

        this.subject = subject;
        return this;
    }

    /**
     * Get subject
     *
     * @return subject
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_SUBJECT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public SecurityEventSubject getSubject() {
        return subject;
    }

    @JsonProperty(JSON_PROPERTY_SUBJECT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setSubject(SecurityEventSubject subject) {
        this.subject = subject;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SecurityEvent securityEvent = (SecurityEvent) o;
        return Objects.equals(this.eventTimestamp, securityEvent.eventTimestamp)
                && Objects.equals(this.subject, securityEvent.subject);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(eventTimestamp, subject);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityEvent {\n");
        sb.append("    eventTimestamp: ").append(toIndentedString(eventTimestamp)).append("\n");
        sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
