package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LinksSelf;
import com.okta.sdk.resource.model.SessionAuthenticationMethod;
import com.okta.sdk.resource.model.SessionIdentityProvider;
import com.okta.sdk.resource.model.SessionStatus;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Session
 */
@JsonPropertyOrder({ Session.JSON_PROPERTY_AMR, Session.JSON_PROPERTY_CREATED_AT, Session.JSON_PROPERTY_EXPIRES_AT,
        Session.JSON_PROPERTY_ID, Session.JSON_PROPERTY_IDP, Session.JSON_PROPERTY_LAST_FACTOR_VERIFICATION,
        Session.JSON_PROPERTY_LAST_PASSWORD_VERIFICATION, Session.JSON_PROPERTY_LOGIN, Session.JSON_PROPERTY_STATUS,
        Session.JSON_PROPERTY_USER_ID, Session.JSON_PROPERTY_LINKS })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class Session implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AMR = "amr";
    private List<SessionAuthenticationMethod> amr = null;

    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;

    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_IDP = "idp";
    private SessionIdentityProvider idp;

    public static final String JSON_PROPERTY_LAST_FACTOR_VERIFICATION = "lastFactorVerification";
    private OffsetDateTime lastFactorVerification;

    public static final String JSON_PROPERTY_LAST_PASSWORD_VERIFICATION = "lastPasswordVerification";
    private OffsetDateTime lastPasswordVerification;

    public static final String JSON_PROPERTY_LOGIN = "login";
    private String login;

    public static final String JSON_PROPERTY_STATUS = "status";
    private SessionStatus status;

    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    public Session() {
    }

    /*
     * @JsonCreator public Session(
     *
     * @JsonProperty(JSON_PROPERTY_AMR) List<SessionAuthenticationMethod> amr,
     *
     * @JsonProperty(JSON_PROPERTY_CREATED_AT) OffsetDateTime createdAt,
     *
     * @JsonProperty(JSON_PROPERTY_EXPIRES_AT) OffsetDateTime expiresAt,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_FACTOR_VERIFICATION) OffsetDateTime lastFactorVerification,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_PASSWORD_VERIFICATION) OffsetDateTime lastPasswordVerification,
     *
     * @JsonProperty(JSON_PROPERTY_LOGIN) String login,
     *
     * @JsonProperty(JSON_PROPERTY_USER_ID) String userId ) { this(); this.amr = amr; this.createdAt = createdAt;
     * this.expiresAt = expiresAt; this.id = id; this.lastFactorVerification = lastFactorVerification;
     * this.lastPasswordVerification = lastPasswordVerification; this.login = login; this.userId = userId; }
     */

    /**
     * Authentication method reference
     *
     * @return amr
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Authentication method reference")
    @JsonProperty(JSON_PROPERTY_AMR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<SessionAuthenticationMethod> getAmr() {
        return amr;
    }

    /**
     * Get createdAt
     *
     * @return createdAt
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREATED_AT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    /**
     * A timestamp when the Session expires
     *
     * @return expiresAt
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A timestamp when the Session expires")
    @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getExpiresAt() {
        return expiresAt;
    }

    /**
     * A unique key for the Session
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A unique key for the Session")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    public Session idp(SessionIdentityProvider idp) {

        this.idp = idp;
        return this;
    }

    /**
     * Get idp
     *
     * @return idp
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_IDP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SessionIdentityProvider getIdp() {
        return idp;
    }

    @JsonProperty(JSON_PROPERTY_IDP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIdp(SessionIdentityProvider idp) {
        this.idp = idp;
    }

    /**
     * A timestamp when the user last performed multifactor authentication
     *
     * @return lastFactorVerification
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A timestamp when the user last performed multifactor authentication")
    @JsonProperty(JSON_PROPERTY_LAST_FACTOR_VERIFICATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastFactorVerification() {
        return lastFactorVerification;
    }

    /**
     * A timestamp when the user last performed the primary or step-up authentication with a password
     *
     * @return lastPasswordVerification
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A timestamp when the user last performed the primary or step-up authentication with a password")
    @JsonProperty(JSON_PROPERTY_LAST_PASSWORD_VERIFICATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastPasswordVerification() {
        return lastPasswordVerification;
    }

    /**
     * A unique identifier for the user (username)
     *
     * @return login
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A unique identifier for the user (username)")
    @JsonProperty(JSON_PROPERTY_LOGIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLogin() {
        return login;
    }

    public Session status(SessionStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SessionStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(SessionStatus status) {
        this.status = status;
    }

    /**
     * A unique key for the user
     *
     * @return userId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A unique key for the user")
    @JsonProperty(JSON_PROPERTY_USER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUserId() {
        return userId;
    }

    public Session links(LinksSelf links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelf getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Session session = (Session) o;
        return Objects.equals(this.amr, session.amr) && Objects.equals(this.createdAt, session.createdAt)
                && Objects.equals(this.expiresAt, session.expiresAt) && Objects.equals(this.id, session.id)
                && Objects.equals(this.idp, session.idp)
                && Objects.equals(this.lastFactorVerification, session.lastFactorVerification)
                && Objects.equals(this.lastPasswordVerification, session.lastPasswordVerification)
                && Objects.equals(this.login, session.login) && Objects.equals(this.status, session.status)
                && Objects.equals(this.userId, session.userId) && Objects.equals(this.links, session.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(amr, createdAt, expiresAt, id, idp, lastFactorVerification, lastPasswordVerification, login,
                status, userId, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Session {\n");
        sb.append("    amr: ").append(toIndentedString(amr)).append("\n");
        sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
        sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    idp: ").append(toIndentedString(idp)).append("\n");
        sb.append("    lastFactorVerification: ").append(toIndentedString(lastFactorVerification)).append("\n");
        sb.append("    lastPasswordVerification: ").append(toIndentedString(lastPasswordVerification)).append("\n");
        sb.append("    login: ").append(toIndentedString(login)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
