package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.WidgetGeneration;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * SignInPageAllOfWidgetCustomizations
 */
@JsonPropertyOrder({ SignInPageAllOfWidgetCustomizations.JSON_PROPERTY_SIGN_IN_LABEL,
        SignInPageAllOfWidgetCustomizations.JSON_PROPERTY_USERNAME_LABEL,
        SignInPageAllOfWidgetCustomizations.JSON_PROPERTY_USERNAME_INFO_TIP,
        SignInPageAllOfWidgetCustomizations.JSON_PROPERTY_PASSWORD_LABEL,
        SignInPageAllOfWidgetCustomizations.JSON_PROPERTY_PASSWORD_INFO_TIP,
        SignInPageAllOfWidgetCustomizations.JSON_PROPERTY_SHOW_PASSWORD_VISIBILITY_TOGGLE,
        SignInPageAllOfWidgetCustomizations.JSON_PROPERTY_SHOW_USER_IDENTIFIER,
        SignInPageAllOfWidgetCustomizations.JSON_PROPERTY_FORGOT_PASSWORD_LABEL,
        SignInPageAllOfWidgetCustomizations.JSON_PROPERTY_FORGOT_PASSWORD_URL,
        SignInPageAllOfWidgetCustomizations.JSON_PROPERTY_UNLOCK_ACCOUNT_LABEL,
        SignInPageAllOfWidgetCustomizations.JSON_PROPERTY_UNLOCK_ACCOUNT_URL,
        SignInPageAllOfWidgetCustomizations.JSON_PROPERTY_HELP_LABEL,
        SignInPageAllOfWidgetCustomizations.JSON_PROPERTY_HELP_URL,
        SignInPageAllOfWidgetCustomizations.JSON_PROPERTY_CUSTOM_LINK1_LABEL,
        SignInPageAllOfWidgetCustomizations.JSON_PROPERTY_CUSTOM_LINK1_URL,
        SignInPageAllOfWidgetCustomizations.JSON_PROPERTY_CUSTOM_LINK2_LABEL,
        SignInPageAllOfWidgetCustomizations.JSON_PROPERTY_CUSTOM_LINK2_URL,
        SignInPageAllOfWidgetCustomizations.JSON_PROPERTY_AUTHENTICATOR_PAGE_CUSTOM_LINK_LABEL,
        SignInPageAllOfWidgetCustomizations.JSON_PROPERTY_AUTHENTICATOR_PAGE_CUSTOM_LINK_URL,
        SignInPageAllOfWidgetCustomizations.JSON_PROPERTY_CLASSIC_RECOVERY_FLOW_EMAIL_OR_USERNAME_LABEL,
        SignInPageAllOfWidgetCustomizations.JSON_PROPERTY_WIDGET_GENERATION })
@JsonTypeName("SignInPage_allOf_widgetCustomizations")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SignInPageAllOfWidgetCustomizations implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SIGN_IN_LABEL = "signInLabel";
    private String signInLabel;

    public static final String JSON_PROPERTY_USERNAME_LABEL = "usernameLabel";
    private String usernameLabel;

    public static final String JSON_PROPERTY_USERNAME_INFO_TIP = "usernameInfoTip";
    private String usernameInfoTip;

    public static final String JSON_PROPERTY_PASSWORD_LABEL = "passwordLabel";
    private String passwordLabel;

    public static final String JSON_PROPERTY_PASSWORD_INFO_TIP = "passwordInfoTip";
    private String passwordInfoTip;

    public static final String JSON_PROPERTY_SHOW_PASSWORD_VISIBILITY_TOGGLE = "showPasswordVisibilityToggle";
    private Boolean showPasswordVisibilityToggle;

    public static final String JSON_PROPERTY_SHOW_USER_IDENTIFIER = "showUserIdentifier";
    private Boolean showUserIdentifier;

    public static final String JSON_PROPERTY_FORGOT_PASSWORD_LABEL = "forgotPasswordLabel";
    private String forgotPasswordLabel;

    public static final String JSON_PROPERTY_FORGOT_PASSWORD_URL = "forgotPasswordUrl";
    private String forgotPasswordUrl;

    public static final String JSON_PROPERTY_UNLOCK_ACCOUNT_LABEL = "unlockAccountLabel";
    private String unlockAccountLabel;

    public static final String JSON_PROPERTY_UNLOCK_ACCOUNT_URL = "unlockAccountUrl";
    private String unlockAccountUrl;

    public static final String JSON_PROPERTY_HELP_LABEL = "helpLabel";
    private String helpLabel;

    public static final String JSON_PROPERTY_HELP_URL = "helpUrl";
    private String helpUrl;

    public static final String JSON_PROPERTY_CUSTOM_LINK1_LABEL = "customLink1Label";
    private String customLink1Label;

    public static final String JSON_PROPERTY_CUSTOM_LINK1_URL = "customLink1Url";
    private String customLink1Url;

    public static final String JSON_PROPERTY_CUSTOM_LINK2_LABEL = "customLink2Label";
    private String customLink2Label;

    public static final String JSON_PROPERTY_CUSTOM_LINK2_URL = "customLink2Url";
    private String customLink2Url;

    public static final String JSON_PROPERTY_AUTHENTICATOR_PAGE_CUSTOM_LINK_LABEL = "authenticatorPageCustomLinkLabel";
    private String authenticatorPageCustomLinkLabel;

    public static final String JSON_PROPERTY_AUTHENTICATOR_PAGE_CUSTOM_LINK_URL = "authenticatorPageCustomLinkUrl";
    private String authenticatorPageCustomLinkUrl;

    public static final String JSON_PROPERTY_CLASSIC_RECOVERY_FLOW_EMAIL_OR_USERNAME_LABEL = "classicRecoveryFlowEmailOrUsernameLabel";
    private String classicRecoveryFlowEmailOrUsernameLabel;

    public static final String JSON_PROPERTY_WIDGET_GENERATION = "widgetGeneration";
    private WidgetGeneration widgetGeneration;

    public SignInPageAllOfWidgetCustomizations() {
    }

    public SignInPageAllOfWidgetCustomizations signInLabel(String signInLabel) {

        this.signInLabel = signInLabel;
        return this;
    }

    /**
     * The label for the sign in widget
     *
     * @return signInLabel
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The label for the sign in widget")
    @JsonProperty(JSON_PROPERTY_SIGN_IN_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getSignInLabel() {
        return signInLabel;
    }

    @JsonProperty(JSON_PROPERTY_SIGN_IN_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSignInLabel(String signInLabel) {
        this.signInLabel = signInLabel;
    }

    public SignInPageAllOfWidgetCustomizations usernameLabel(String usernameLabel) {

        this.usernameLabel = usernameLabel;
        return this;
    }

    /**
     * The label for the username field
     *
     * @return usernameLabel
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The label for the username field")
    @JsonProperty(JSON_PROPERTY_USERNAME_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUsernameLabel() {
        return usernameLabel;
    }

    @JsonProperty(JSON_PROPERTY_USERNAME_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUsernameLabel(String usernameLabel) {
        this.usernameLabel = usernameLabel;
    }

    public SignInPageAllOfWidgetCustomizations usernameInfoTip(String usernameInfoTip) {

        this.usernameInfoTip = usernameInfoTip;
        return this;
    }

    /**
     * The label for the username information tip
     *
     * @return usernameInfoTip
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The label for the username information tip")
    @JsonProperty(JSON_PROPERTY_USERNAME_INFO_TIP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUsernameInfoTip() {
        return usernameInfoTip;
    }

    @JsonProperty(JSON_PROPERTY_USERNAME_INFO_TIP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUsernameInfoTip(String usernameInfoTip) {
        this.usernameInfoTip = usernameInfoTip;
    }

    public SignInPageAllOfWidgetCustomizations passwordLabel(String passwordLabel) {

        this.passwordLabel = passwordLabel;
        return this;
    }

    /**
     * The label for the password field
     *
     * @return passwordLabel
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The label for the password field")
    @JsonProperty(JSON_PROPERTY_PASSWORD_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPasswordLabel() {
        return passwordLabel;
    }

    @JsonProperty(JSON_PROPERTY_PASSWORD_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPasswordLabel(String passwordLabel) {
        this.passwordLabel = passwordLabel;
    }

    public SignInPageAllOfWidgetCustomizations passwordInfoTip(String passwordInfoTip) {

        this.passwordInfoTip = passwordInfoTip;
        return this;
    }

    /**
     * The label for the password information tip
     *
     * @return passwordInfoTip
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The label for the password information tip")
    @JsonProperty(JSON_PROPERTY_PASSWORD_INFO_TIP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPasswordInfoTip() {
        return passwordInfoTip;
    }

    @JsonProperty(JSON_PROPERTY_PASSWORD_INFO_TIP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPasswordInfoTip(String passwordInfoTip) {
        this.passwordInfoTip = passwordInfoTip;
    }

    public SignInPageAllOfWidgetCustomizations showPasswordVisibilityToggle(Boolean showPasswordVisibilityToggle) {

        this.showPasswordVisibilityToggle = showPasswordVisibilityToggle;
        return this;
    }

    /**
     * Allows users to see their passwords as they type
     *
     * @return showPasswordVisibilityToggle
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Allows users to see their passwords as they type")
    @JsonProperty(JSON_PROPERTY_SHOW_PASSWORD_VISIBILITY_TOGGLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getShowPasswordVisibilityToggle() {
        return showPasswordVisibilityToggle;
    }

    @JsonProperty(JSON_PROPERTY_SHOW_PASSWORD_VISIBILITY_TOGGLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setShowPasswordVisibilityToggle(Boolean showPasswordVisibilityToggle) {
        this.showPasswordVisibilityToggle = showPasswordVisibilityToggle;
    }

    public SignInPageAllOfWidgetCustomizations showUserIdentifier(Boolean showUserIdentifier) {

        this.showUserIdentifier = showUserIdentifier;
        return this;
    }

    /**
     * Allows the user&#39;s identifier to appear on authentication and enrollment pages
     *
     * @return showUserIdentifier
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Allows the user's identifier to appear on authentication and enrollment pages")
    @JsonProperty(JSON_PROPERTY_SHOW_USER_IDENTIFIER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getShowUserIdentifier() {
        return showUserIdentifier;
    }

    @JsonProperty(JSON_PROPERTY_SHOW_USER_IDENTIFIER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setShowUserIdentifier(Boolean showUserIdentifier) {
        this.showUserIdentifier = showUserIdentifier;
    }

    public SignInPageAllOfWidgetCustomizations forgotPasswordLabel(String forgotPasswordLabel) {

        this.forgotPasswordLabel = forgotPasswordLabel;
        return this;
    }

    /**
     * The label for the forgot password page
     *
     * @return forgotPasswordLabel
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The label for the forgot password page")
    @JsonProperty(JSON_PROPERTY_FORGOT_PASSWORD_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getForgotPasswordLabel() {
        return forgotPasswordLabel;
    }

    @JsonProperty(JSON_PROPERTY_FORGOT_PASSWORD_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setForgotPasswordLabel(String forgotPasswordLabel) {
        this.forgotPasswordLabel = forgotPasswordLabel;
    }

    public SignInPageAllOfWidgetCustomizations forgotPasswordUrl(String forgotPasswordUrl) {

        this.forgotPasswordUrl = forgotPasswordUrl;
        return this;
    }

    /**
     * The forgot password URL
     *
     * @return forgotPasswordUrl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The forgot password URL")
    @JsonProperty(JSON_PROPERTY_FORGOT_PASSWORD_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getForgotPasswordUrl() {
        return forgotPasswordUrl;
    }

    @JsonProperty(JSON_PROPERTY_FORGOT_PASSWORD_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setForgotPasswordUrl(String forgotPasswordUrl) {
        this.forgotPasswordUrl = forgotPasswordUrl;
    }

    public SignInPageAllOfWidgetCustomizations unlockAccountLabel(String unlockAccountLabel) {

        this.unlockAccountLabel = unlockAccountLabel;
        return this;
    }

    /**
     * The label for the unlock account link
     *
     * @return unlockAccountLabel
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The label for the unlock account link")
    @JsonProperty(JSON_PROPERTY_UNLOCK_ACCOUNT_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUnlockAccountLabel() {
        return unlockAccountLabel;
    }

    @JsonProperty(JSON_PROPERTY_UNLOCK_ACCOUNT_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUnlockAccountLabel(String unlockAccountLabel) {
        this.unlockAccountLabel = unlockAccountLabel;
    }

    public SignInPageAllOfWidgetCustomizations unlockAccountUrl(String unlockAccountUrl) {

        this.unlockAccountUrl = unlockAccountUrl;
        return this;
    }

    /**
     * The unlock account URL
     *
     * @return unlockAccountUrl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The unlock account URL")
    @JsonProperty(JSON_PROPERTY_UNLOCK_ACCOUNT_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUnlockAccountUrl() {
        return unlockAccountUrl;
    }

    @JsonProperty(JSON_PROPERTY_UNLOCK_ACCOUNT_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUnlockAccountUrl(String unlockAccountUrl) {
        this.unlockAccountUrl = unlockAccountUrl;
    }

    public SignInPageAllOfWidgetCustomizations helpLabel(String helpLabel) {

        this.helpLabel = helpLabel;
        return this;
    }

    /**
     * The label for the help link
     *
     * @return helpLabel
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The label for the help link")
    @JsonProperty(JSON_PROPERTY_HELP_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getHelpLabel() {
        return helpLabel;
    }

    @JsonProperty(JSON_PROPERTY_HELP_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHelpLabel(String helpLabel) {
        this.helpLabel = helpLabel;
    }

    public SignInPageAllOfWidgetCustomizations helpUrl(String helpUrl) {

        this.helpUrl = helpUrl;
        return this;
    }

    /**
     * The help link URL
     *
     * @return helpUrl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The help link URL")
    @JsonProperty(JSON_PROPERTY_HELP_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getHelpUrl() {
        return helpUrl;
    }

    @JsonProperty(JSON_PROPERTY_HELP_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHelpUrl(String helpUrl) {
        this.helpUrl = helpUrl;
    }

    public SignInPageAllOfWidgetCustomizations customLink1Label(String customLink1Label) {

        this.customLink1Label = customLink1Label;
        return this;
    }

    /**
     * The label for the first custom link
     *
     * @return customLink1Label
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The label for the first custom link")
    @JsonProperty(JSON_PROPERTY_CUSTOM_LINK1_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCustomLink1Label() {
        return customLink1Label;
    }

    @JsonProperty(JSON_PROPERTY_CUSTOM_LINK1_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCustomLink1Label(String customLink1Label) {
        this.customLink1Label = customLink1Label;
    }

    public SignInPageAllOfWidgetCustomizations customLink1Url(String customLink1Url) {

        this.customLink1Url = customLink1Url;
        return this;
    }

    /**
     * The URL for the first custom link
     *
     * @return customLink1Url
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The URL for the first custom link")
    @JsonProperty(JSON_PROPERTY_CUSTOM_LINK1_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCustomLink1Url() {
        return customLink1Url;
    }

    @JsonProperty(JSON_PROPERTY_CUSTOM_LINK1_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCustomLink1Url(String customLink1Url) {
        this.customLink1Url = customLink1Url;
    }

    public SignInPageAllOfWidgetCustomizations customLink2Label(String customLink2Label) {

        this.customLink2Label = customLink2Label;
        return this;
    }

    /**
     * The label for the second custom link
     *
     * @return customLink2Label
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The label for the second custom link")
    @JsonProperty(JSON_PROPERTY_CUSTOM_LINK2_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCustomLink2Label() {
        return customLink2Label;
    }

    @JsonProperty(JSON_PROPERTY_CUSTOM_LINK2_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCustomLink2Label(String customLink2Label) {
        this.customLink2Label = customLink2Label;
    }

    public SignInPageAllOfWidgetCustomizations customLink2Url(String customLink2Url) {

        this.customLink2Url = customLink2Url;
        return this;
    }

    /**
     * The URL for the second custom link
     *
     * @return customLink2Url
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The URL for the second custom link")
    @JsonProperty(JSON_PROPERTY_CUSTOM_LINK2_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCustomLink2Url() {
        return customLink2Url;
    }

    @JsonProperty(JSON_PROPERTY_CUSTOM_LINK2_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCustomLink2Url(String customLink2Url) {
        this.customLink2Url = customLink2Url;
    }

    public SignInPageAllOfWidgetCustomizations authenticatorPageCustomLinkLabel(
            String authenticatorPageCustomLinkLabel) {

        this.authenticatorPageCustomLinkLabel = authenticatorPageCustomLinkLabel;
        return this;
    }

    /**
     * The label for the authenticator page custom link
     *
     * @return authenticatorPageCustomLinkLabel
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The label for the authenticator page custom link")
    @JsonProperty(JSON_PROPERTY_AUTHENTICATOR_PAGE_CUSTOM_LINK_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAuthenticatorPageCustomLinkLabel() {
        return authenticatorPageCustomLinkLabel;
    }

    @JsonProperty(JSON_PROPERTY_AUTHENTICATOR_PAGE_CUSTOM_LINK_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticatorPageCustomLinkLabel(String authenticatorPageCustomLinkLabel) {
        this.authenticatorPageCustomLinkLabel = authenticatorPageCustomLinkLabel;
    }

    public SignInPageAllOfWidgetCustomizations authenticatorPageCustomLinkUrl(String authenticatorPageCustomLinkUrl) {

        this.authenticatorPageCustomLinkUrl = authenticatorPageCustomLinkUrl;
        return this;
    }

    /**
     * The URL for the authenticator page custom link
     *
     * @return authenticatorPageCustomLinkUrl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The URL for the authenticator page custom link")
    @JsonProperty(JSON_PROPERTY_AUTHENTICATOR_PAGE_CUSTOM_LINK_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAuthenticatorPageCustomLinkUrl() {
        return authenticatorPageCustomLinkUrl;
    }

    @JsonProperty(JSON_PROPERTY_AUTHENTICATOR_PAGE_CUSTOM_LINK_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticatorPageCustomLinkUrl(String authenticatorPageCustomLinkUrl) {
        this.authenticatorPageCustomLinkUrl = authenticatorPageCustomLinkUrl;
    }

    public SignInPageAllOfWidgetCustomizations classicRecoveryFlowEmailOrUsernameLabel(
            String classicRecoveryFlowEmailOrUsernameLabel) {

        this.classicRecoveryFlowEmailOrUsernameLabel = classicRecoveryFlowEmailOrUsernameLabel;
        return this;
    }

    /**
     * The label for the username field in the classic recovery flow
     *
     * @return classicRecoveryFlowEmailOrUsernameLabel
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The label for the username field in the classic recovery flow")
    @JsonProperty(JSON_PROPERTY_CLASSIC_RECOVERY_FLOW_EMAIL_OR_USERNAME_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClassicRecoveryFlowEmailOrUsernameLabel() {
        return classicRecoveryFlowEmailOrUsernameLabel;
    }

    @JsonProperty(JSON_PROPERTY_CLASSIC_RECOVERY_FLOW_EMAIL_OR_USERNAME_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClassicRecoveryFlowEmailOrUsernameLabel(String classicRecoveryFlowEmailOrUsernameLabel) {
        this.classicRecoveryFlowEmailOrUsernameLabel = classicRecoveryFlowEmailOrUsernameLabel;
    }

    public SignInPageAllOfWidgetCustomizations widgetGeneration(WidgetGeneration widgetGeneration) {

        this.widgetGeneration = widgetGeneration;
        return this;
    }

    /**
     * Get widgetGeneration
     *
     * @return widgetGeneration
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_WIDGET_GENERATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public WidgetGeneration getWidgetGeneration() {
        return widgetGeneration;
    }

    @JsonProperty(JSON_PROPERTY_WIDGET_GENERATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setWidgetGeneration(WidgetGeneration widgetGeneration) {
        this.widgetGeneration = widgetGeneration;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SignInPageAllOfWidgetCustomizations signInPageAllOfWidgetCustomizations = (SignInPageAllOfWidgetCustomizations) o;
        return Objects.equals(this.signInLabel, signInPageAllOfWidgetCustomizations.signInLabel)
                && Objects.equals(this.usernameLabel, signInPageAllOfWidgetCustomizations.usernameLabel)
                && Objects.equals(this.usernameInfoTip, signInPageAllOfWidgetCustomizations.usernameInfoTip)
                && Objects.equals(this.passwordLabel, signInPageAllOfWidgetCustomizations.passwordLabel)
                && Objects.equals(this.passwordInfoTip, signInPageAllOfWidgetCustomizations.passwordInfoTip)
                && Objects.equals(this.showPasswordVisibilityToggle,
                        signInPageAllOfWidgetCustomizations.showPasswordVisibilityToggle)
                && Objects.equals(this.showUserIdentifier, signInPageAllOfWidgetCustomizations.showUserIdentifier)
                && Objects.equals(this.forgotPasswordLabel, signInPageAllOfWidgetCustomizations.forgotPasswordLabel)
                && Objects.equals(this.forgotPasswordUrl, signInPageAllOfWidgetCustomizations.forgotPasswordUrl)
                && Objects.equals(this.unlockAccountLabel, signInPageAllOfWidgetCustomizations.unlockAccountLabel)
                && Objects.equals(this.unlockAccountUrl, signInPageAllOfWidgetCustomizations.unlockAccountUrl)
                && Objects.equals(this.helpLabel, signInPageAllOfWidgetCustomizations.helpLabel)
                && Objects.equals(this.helpUrl, signInPageAllOfWidgetCustomizations.helpUrl)
                && Objects.equals(this.customLink1Label, signInPageAllOfWidgetCustomizations.customLink1Label)
                && Objects.equals(this.customLink1Url, signInPageAllOfWidgetCustomizations.customLink1Url)
                && Objects.equals(this.customLink2Label, signInPageAllOfWidgetCustomizations.customLink2Label)
                && Objects.equals(this.customLink2Url, signInPageAllOfWidgetCustomizations.customLink2Url)
                && Objects.equals(this.authenticatorPageCustomLinkLabel,
                        signInPageAllOfWidgetCustomizations.authenticatorPageCustomLinkLabel)
                && Objects.equals(this.authenticatorPageCustomLinkUrl,
                        signInPageAllOfWidgetCustomizations.authenticatorPageCustomLinkUrl)
                && Objects.equals(this.classicRecoveryFlowEmailOrUsernameLabel,
                        signInPageAllOfWidgetCustomizations.classicRecoveryFlowEmailOrUsernameLabel)
                && Objects.equals(this.widgetGeneration, signInPageAllOfWidgetCustomizations.widgetGeneration);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(signInLabel, usernameLabel, usernameInfoTip, passwordLabel, passwordInfoTip,
                showPasswordVisibilityToggle, showUserIdentifier, forgotPasswordLabel, forgotPasswordUrl,
                unlockAccountLabel, unlockAccountUrl, helpLabel, helpUrl, customLink1Label, customLink1Url,
                customLink2Label, customLink2Url, authenticatorPageCustomLinkLabel, authenticatorPageCustomLinkUrl,
                classicRecoveryFlowEmailOrUsernameLabel, widgetGeneration);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignInPageAllOfWidgetCustomizations {\n");
        sb.append("    signInLabel: ").append(toIndentedString(signInLabel)).append("\n");
        sb.append("    usernameLabel: ").append(toIndentedString(usernameLabel)).append("\n");
        sb.append("    usernameInfoTip: ").append(toIndentedString(usernameInfoTip)).append("\n");
        sb.append("    passwordLabel: ").append(toIndentedString(passwordLabel)).append("\n");
        sb.append("    passwordInfoTip: ").append(toIndentedString(passwordInfoTip)).append("\n");
        sb.append("    showPasswordVisibilityToggle: ").append(toIndentedString(showPasswordVisibilityToggle))
                .append("\n");
        sb.append("    showUserIdentifier: ").append(toIndentedString(showUserIdentifier)).append("\n");
        sb.append("    forgotPasswordLabel: ").append(toIndentedString(forgotPasswordLabel)).append("\n");
        sb.append("    forgotPasswordUrl: ").append(toIndentedString(forgotPasswordUrl)).append("\n");
        sb.append("    unlockAccountLabel: ").append(toIndentedString(unlockAccountLabel)).append("\n");
        sb.append("    unlockAccountUrl: ").append(toIndentedString(unlockAccountUrl)).append("\n");
        sb.append("    helpLabel: ").append(toIndentedString(helpLabel)).append("\n");
        sb.append("    helpUrl: ").append(toIndentedString(helpUrl)).append("\n");
        sb.append("    customLink1Label: ").append(toIndentedString(customLink1Label)).append("\n");
        sb.append("    customLink1Url: ").append(toIndentedString(customLink1Url)).append("\n");
        sb.append("    customLink2Label: ").append(toIndentedString(customLink2Label)).append("\n");
        sb.append("    customLink2Url: ").append(toIndentedString(customLink2Url)).append("\n");
        sb.append("    authenticatorPageCustomLinkLabel: ").append(toIndentedString(authenticatorPageCustomLinkLabel))
                .append("\n");
        sb.append("    authenticatorPageCustomLinkUrl: ").append(toIndentedString(authenticatorPageCustomLinkUrl))
                .append("\n");
        sb.append("    classicRecoveryFlowEmailOrUsernameLabel: ")
                .append(toIndentedString(classicRecoveryFlowEmailOrUsernameLabel)).append("\n");
        sb.append("    widgetGeneration: ").append(toIndentedString(widgetGeneration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
