package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OIDC test details
 */
@ApiModel(description = "OIDC test details")
@JsonPropertyOrder({ TestInfoOidcTestConfiguration.JSON_PROPERTY_IDP, TestInfoOidcTestConfiguration.JSON_PROPERTY_SP,
        TestInfoOidcTestConfiguration.JSON_PROPERTY_JIT, TestInfoOidcTestConfiguration.JSON_PROPERTY_SP_INITIATE_URL })
@JsonTypeName("TestInfo_oidcTestConfiguration")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class TestInfoOidcTestConfiguration implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_IDP = "idp";
    private Boolean idp;

    public static final String JSON_PROPERTY_SP = "sp";
    private Boolean sp;

    public static final String JSON_PROPERTY_JIT = "jit";
    private Boolean jit;

    public static final String JSON_PROPERTY_SP_INITIATE_URL = "spInitiateUrl";
    private URI spInitiateUrl;

    public TestInfoOidcTestConfiguration() {
    }

    /*
     * @JsonCreator public TestInfoOidcTestConfiguration(
     *
     * @JsonProperty(JSON_PROPERTY_IDP) Boolean idp,
     *
     * @JsonProperty(JSON_PROPERTY_SP) Boolean sp ) { this(); this.idp = idp; this.sp = sp; }
     */

    /**
     * Read only.&lt;br&gt;Indicates if your integration supports IdP-initiated sign-in flows. If
     * [&#x60;sso.oidc.initiateLoginUri&#x60;](/openapi/okta-management/management/tag/YourOinIntegrations/#tag/YourOinIntegrations/operation/createSubmission!path&#x3D;sso/oidc/initiateLoginUri&amp;t&#x3D;request)
     * is specified, this property is set to &#x60;true&#x60;. If
     * [&#x60;sso.oidc.initiateLoginUri&#x60;](/openapi/okta-management/management/tag/YourOinIntegrations/#tag/YourOinIntegrations/operation/createSubmission!path&#x3D;sso/oidc/initiateLoginUri&amp;t&#x3D;request)
     * isn&#39;t set for the integration submission, this property is set to &#x60;false&#x60;
     *
     * @return idp
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Read only.<br>Indicates if your integration supports IdP-initiated sign-in flows. If [`sso.oidc.initiateLoginUri`](/openapi/okta-management/management/tag/YourOinIntegrations/#tag/YourOinIntegrations/operation/createSubmission!path=sso/oidc/initiateLoginUri&t=request) is specified, this property is set to `true`. If [`sso.oidc.initiateLoginUri`](/openapi/okta-management/management/tag/YourOinIntegrations/#tag/YourOinIntegrations/operation/createSubmission!path=sso/oidc/initiateLoginUri&t=request) isn't set for the integration submission, this property is set to `false`")
    @JsonProperty(JSON_PROPERTY_IDP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getIdp() {
        return idp;
    }

    /**
     * Read only.&lt;br&gt;Indicates if your integration supports SP-initiated sign-in flows and is always set to
     * &#x60;true&#x60; for OIDC SSO
     *
     * @return sp
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Read only.<br>Indicates if your integration supports SP-initiated sign-in flows and is always set to `true` for OIDC SSO")
    @JsonProperty(JSON_PROPERTY_SP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getSp() {
        return sp;
    }

    public TestInfoOidcTestConfiguration jit(Boolean jit) {

        this.jit = jit;
        return this;
    }

    /**
     * Indicates if your integration supports Just-In-Time (JIT) provisioning
     *
     * @return jit
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if your integration supports Just-In-Time (JIT) provisioning")
    @JsonProperty(JSON_PROPERTY_JIT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getJit() {
        return jit;
    }

    @JsonProperty(JSON_PROPERTY_JIT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setJit(Boolean jit) {
        this.jit = jit;
    }

    public TestInfoOidcTestConfiguration spInitiateUrl(URI spInitiateUrl) {

        this.spInitiateUrl = spInitiateUrl;
        return this;
    }

    /**
     * URL for SP-initiated sign-in flows (required if &#x60;sp &#x3D; true&#x60;)
     *
     * @return spInitiateUrl
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "https://test.example.com/strawberry/oidc/sp-init", required = true, value = "URL for SP-initiated sign-in flows (required if `sp = true`)")
    @JsonProperty(JSON_PROPERTY_SP_INITIATE_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public URI getSpInitiateUrl() {
        return spInitiateUrl;
    }

    @JsonProperty(JSON_PROPERTY_SP_INITIATE_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setSpInitiateUrl(URI spInitiateUrl) {
        this.spInitiateUrl = spInitiateUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TestInfoOidcTestConfiguration testInfoOidcTestConfiguration = (TestInfoOidcTestConfiguration) o;
        return Objects.equals(this.idp, testInfoOidcTestConfiguration.idp)
                && Objects.equals(this.sp, testInfoOidcTestConfiguration.sp)
                && Objects.equals(this.jit, testInfoOidcTestConfiguration.jit)
                && Objects.equals(this.spInitiateUrl, testInfoOidcTestConfiguration.spInitiateUrl);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(idp, sp, jit, spInitiateUrl);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestInfoOidcTestConfiguration {\n");
        sb.append("    idp: ").append(toIndentedString(idp)).append("\n");
        sb.append("    sp: ").append(toIndentedString(sp)).append("\n");
        sb.append("    jit: ").append(toIndentedString(jit)).append("\n");
        sb.append("    spInitiateUrl: ").append(toIndentedString(spInitiateUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
