package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * An account on a test instance of your app with admin privileges. A test admin account is required by Okta for
 * integration testing. During OIN QA testing, an Okta analyst uses this admin account to configure your app for the
 * various test case flows.
 */
@ApiModel(description = "An account on a test instance of your app with admin privileges. A test admin account is required by Okta for integration testing. During OIN QA testing, an Okta analyst uses this admin account to configure your app for the various test case flows.")
@JsonPropertyOrder({ TestInfoTestAccount.JSON_PROPERTY_URL, TestInfoTestAccount.JSON_PROPERTY_USERNAME,
        TestInfoTestAccount.JSON_PROPERTY_PASSWORD, TestInfoTestAccount.JSON_PROPERTY_INSTRUCTIONS })
@JsonTypeName("TestInfo_testAccount")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class TestInfoTestAccount implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_URL = "url";
    private URI url;

    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;

    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password;

    public static final String JSON_PROPERTY_INSTRUCTIONS = "instructions";
    private String instructions;

    public TestInfoTestAccount() {
    }

    public TestInfoTestAccount url(URI url) {

        this.url = url;
        return this;
    }

    /**
     * The sign-in URL to a test instance of your app
     *
     * @return url
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "https://example.com/strawberry/login", required = true, value = "The sign-in URL to a test instance of your app")
    @JsonProperty(JSON_PROPERTY_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public URI getUrl() {
        return url;
    }

    @JsonProperty(JSON_PROPERTY_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setUrl(URI url) {
        this.url = url;
    }

    public TestInfoTestAccount username(String username) {

        this.username = username;
        return this;
    }

    /**
     * The username for your app admin account
     *
     * @return username
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "test@example.com", required = true, value = "The username for your app admin account")
    @JsonProperty(JSON_PROPERTY_USERNAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getUsername() {
        return username;
    }

    @JsonProperty(JSON_PROPERTY_USERNAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setUsername(String username) {
        this.username = username;
    }

    public TestInfoTestAccount password(String password) {

        this.password = password;
        return this;
    }

    /**
     * The password for your app admin account
     *
     * @return password
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "sUperP@ssw0rd", required = true, value = "The password for your app admin account")
    @JsonProperty(JSON_PROPERTY_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getPassword() {
        return password;
    }

    @JsonProperty(JSON_PROPERTY_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setPassword(String password) {
        this.password = password;
    }

    public TestInfoTestAccount instructions(String instructions) {

        this.instructions = instructions;
        return this;
    }

    /**
     * Additional instructions to test the app integration, including instructions for obtaining test accounts
     *
     * @return instructions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "Go to your app URL from a browser and enter your credentials", value = "Additional instructions to test the app integration, including instructions for obtaining test accounts")
    @JsonProperty(JSON_PROPERTY_INSTRUCTIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getInstructions() {
        return instructions;
    }

    @JsonProperty(JSON_PROPERTY_INSTRUCTIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TestInfoTestAccount testInfoTestAccount = (TestInfoTestAccount) o;
        return Objects.equals(this.url, testInfoTestAccount.url)
                && Objects.equals(this.username, testInfoTestAccount.username)
                && Objects.equals(this.password, testInfoTestAccount.password)
                && Objects.equals(this.instructions, testInfoTestAccount.instructions);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(url, username, password, instructions);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestInfoTestAccount {\n");
        sb.append("    url: ").append(toIndentedString(url)).append("\n");
        sb.append("    username: ").append(toIndentedString(username)).append("\n");
        sb.append("    password: ").append(toIndentedString(password)).append("\n");
        sb.append("    instructions: ").append(toIndentedString(instructions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
