package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.TokenHookResponseCommandsInner;
import com.okta.sdk.resource.model.TokenHookResponseError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * For the token inline hook, the &#x60;commands&#x60; and &#x60;error&#x60; objects that you can return in the JSON
 * payload of your response are defined in the following sections. &gt; **Note:** The size of your response payload must
 * be less than 256 KB.
 */
@ApiModel(description = "For the token inline hook, the `commands` and `error` objects that you can return in the JSON payload of your response are defined in the following sections. > **Note:** The size of your response payload must be less than 256 KB.")
@JsonPropertyOrder({ TokenHookResponse.JSON_PROPERTY_COMMANDS, TokenHookResponse.JSON_PROPERTY_ERROR })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class TokenHookResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_COMMANDS = "commands";
    private List<TokenHookResponseCommandsInner> commands = null;

    public static final String JSON_PROPERTY_ERROR = "error";
    private TokenHookResponseError error;

    public TokenHookResponse() {
    }

    public TokenHookResponse commands(List<TokenHookResponseCommandsInner> commands) {

        this.commands = commands;
        return this;
    }

    public TokenHookResponse addcommandsItem(TokenHookResponseCommandsInner commandsItem) {
        if (this.commands == null) {
            this.commands = new ArrayList<>();
        }
        this.commands.add(commandsItem);
        return this;
    }

    /**
     * You can use the &#x60;commands&#x60; object to provide commands to Okta. It&#39;s where you can tell Okta to add
     * more claims to the token. The &#x60;commands&#x60; object is an array, allowing you to send multiple commands. In
     * each array element, there needs to be a &#x60;type&#x60; property and &#x60;value&#x60; property. The
     * &#x60;type&#x60; property is where you specify which of the supported commands you want to execute, and
     * &#x60;value&#x60; is where you supply an operand for that command. In the case of the token hook type, the
     * &#x60;value&#x60; property is itself a nested object in which you specify a particular operation, a path to act
     * on, and a value.
     *
     * @return commands
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "You can use the `commands` object to provide commands to Okta. It's where you can tell Okta to add more claims to the token. The `commands` object is an array, allowing you to send multiple commands. In each array element, there needs to be a `type` property and `value` property. The `type` property is where you specify which of the supported commands you want to execute, and `value` is where you supply an operand for that command. In the case of the token hook type, the `value` property is itself a nested object in which you specify a particular operation, a path to act on, and a value.")
    @JsonProperty(JSON_PROPERTY_COMMANDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<TokenHookResponseCommandsInner> getCommands() {
        return commands;
    }

    @JsonProperty(JSON_PROPERTY_COMMANDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCommands(List<TokenHookResponseCommandsInner> commands) {
        this.commands = commands;
    }

    public TokenHookResponse error(TokenHookResponseError error) {

        this.error = error;
        return this;
    }

    /**
     * Get error
     *
     * @return error
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ERROR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TokenHookResponseError getError() {
        return error;
    }

    @JsonProperty(JSON_PROPERTY_ERROR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setError(TokenHookResponseError error) {
        this.error = error;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TokenHookResponse tokenHookResponse = (TokenHookResponse) o;
        return Objects.equals(this.commands, tokenHookResponse.commands)
                && Objects.equals(this.error, tokenHookResponse.error);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(commands, error);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenHookResponse {\n");
        sb.append("    commands: ").append(toIndentedString(commands)).append("\n");
        sb.append("    error: ").append(toIndentedString(error)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
