package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.RefreshToken;
import com.okta.sdk.resource.model.TokenPayLoadDataAccess;
import com.okta.sdk.resource.model.TokenPayLoadDataContext;
import com.okta.sdk.resource.model.TokenPayLoadDataIdentity;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * TokenPayLoadData
 */
@JsonPropertyOrder({ TokenPayLoadData.JSON_PROPERTY_CONTEXT, TokenPayLoadData.JSON_PROPERTY_IDENTITY,
        TokenPayLoadData.JSON_PROPERTY_ACCESS, TokenPayLoadData.JSON_PROPERTY_REFRESH_TOKEN })
@JsonTypeName("TokenPayLoad_data")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class TokenPayLoadData implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CONTEXT = "context";
    private TokenPayLoadDataContext context;

    public static final String JSON_PROPERTY_IDENTITY = "identity";
    private TokenPayLoadDataIdentity identity;

    public static final String JSON_PROPERTY_ACCESS = "access";
    private TokenPayLoadDataAccess access;

    public static final String JSON_PROPERTY_REFRESH_TOKEN = "refresh_token";
    private RefreshToken refreshToken;

    public TokenPayLoadData() {
    }

    public TokenPayLoadData context(TokenPayLoadDataContext context) {

        this.context = context;
        return this;
    }

    /**
     * Get context
     *
     * @return context
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CONTEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TokenPayLoadDataContext getContext() {
        return context;
    }

    @JsonProperty(JSON_PROPERTY_CONTEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setContext(TokenPayLoadDataContext context) {
        this.context = context;
    }

    public TokenPayLoadData identity(TokenPayLoadDataIdentity identity) {

        this.identity = identity;
        return this;
    }

    /**
     * Get identity
     *
     * @return identity
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_IDENTITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TokenPayLoadDataIdentity getIdentity() {
        return identity;
    }

    @JsonProperty(JSON_PROPERTY_IDENTITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIdentity(TokenPayLoadDataIdentity identity) {
        this.identity = identity;
    }

    public TokenPayLoadData access(TokenPayLoadDataAccess access) {

        this.access = access;
        return this;
    }

    /**
     * Get access
     *
     * @return access
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ACCESS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TokenPayLoadDataAccess getAccess() {
        return access;
    }

    @JsonProperty(JSON_PROPERTY_ACCESS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAccess(TokenPayLoadDataAccess access) {
        this.access = access;
    }

    public TokenPayLoadData refreshToken(RefreshToken refreshToken) {

        this.refreshToken = refreshToken;
        return this;
    }

    /**
     * Get refreshToken
     *
     * @return refreshToken
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REFRESH_TOKEN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public RefreshToken getRefreshToken() {
        return refreshToken;
    }

    @JsonProperty(JSON_PROPERTY_REFRESH_TOKEN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRefreshToken(RefreshToken refreshToken) {
        this.refreshToken = refreshToken;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TokenPayLoadData tokenPayLoadData = (TokenPayLoadData) o;
        return Objects.equals(this.context, tokenPayLoadData.context)
                && Objects.equals(this.identity, tokenPayLoadData.identity)
                && Objects.equals(this.access, tokenPayLoadData.access)
                && Objects.equals(this.refreshToken, tokenPayLoadData.refreshToken);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(context, identity, access, refreshToken);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenPayLoadData {\n");
        sb.append("    context: ").append(toIndentedString(context)).append("\n");
        sb.append("    identity: ").append(toIndentedString(identity)).append("\n");
        sb.append("    access: ").append(toIndentedString(access)).append("\n");
        sb.append("    refreshToken: ").append(toIndentedString(refreshToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
