package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.BaseTokenLifetime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * TokenPayLoadDataIdentity
 */
@JsonPropertyOrder({ TokenPayLoadDataIdentity.JSON_PROPERTY_CLAIMS, TokenPayLoadDataIdentity.JSON_PROPERTY_LIFETIME })
@JsonTypeName("TokenPayLoad_data_identity")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class TokenPayLoadDataIdentity implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CLAIMS = "claims";
    private Object claims;

    public static final String JSON_PROPERTY_LIFETIME = "lifetime";
    private BaseTokenLifetime lifetime;

    public TokenPayLoadDataIdentity() {
    }

    public TokenPayLoadDataIdentity claims(Object claims) {

        this.claims = claims;
        return this;
    }

    /**
     * Claims included in the token. Consists of name-value pairs for each included claim. For descriptions of the
     * claims that you can include, see the Okta [OpenID Connect and OAuth 2.0 API
     * reference](/openapi/okta-oauth/guides/overview/#claims).
     *
     * @return claims
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Claims included in the token. Consists of name-value pairs for each included claim. For descriptions of the claims that you can include, see the Okta [OpenID Connect and OAuth 2.0 API reference](/openapi/okta-oauth/guides/overview/#claims).")
    @JsonProperty(JSON_PROPERTY_CLAIMS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Object getClaims() {
        return claims;
    }

    @JsonProperty(JSON_PROPERTY_CLAIMS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClaims(Object claims) {
        this.claims = claims;
    }

    public TokenPayLoadDataIdentity lifetime(BaseTokenLifetime lifetime) {

        this.lifetime = lifetime;
        return this;
    }

    /**
     * Get lifetime
     *
     * @return lifetime
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LIFETIME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public BaseTokenLifetime getLifetime() {
        return lifetime;
    }

    @JsonProperty(JSON_PROPERTY_LIFETIME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLifetime(BaseTokenLifetime lifetime) {
        this.lifetime = lifetime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TokenPayLoadDataIdentity tokenPayLoadDataIdentity = (TokenPayLoadDataIdentity) o;
        return Objects.equals(this.claims, tokenPayLoadDataIdentity.claims)
                && Objects.equals(this.lifetime, tokenPayLoadDataIdentity.lifetime);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(claims, lifetime);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenPayLoadDataIdentity {\n");
        sb.append("    claims: ").append(toIndentedString(claims)).append("\n");
        sb.append("    lifetime: ").append(toIndentedString(lifetime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
