package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LinksSelf;
import com.okta.sdk.resource.model.UISchemaObject;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UISchemasResponseObject
 */
@JsonPropertyOrder({ UISchemasResponseObject.JSON_PROPERTY_CREATED, UISchemasResponseObject.JSON_PROPERTY_ID,
        UISchemasResponseObject.JSON_PROPERTY_LAST_UPDATED, UISchemasResponseObject.JSON_PROPERTY_UI_SCHEMA,
        UISchemasResponseObject.JSON_PROPERTY_LINKS })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class UISchemasResponseObject implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_UI_SCHEMA = "uiSchema";
    private UISchemaObject uiSchema;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    public UISchemasResponseObject() {
    }

    /*
     * @JsonCreator public UISchemasResponseObject(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.created = created; this.id
     * = id; this.lastUpdated = lastUpdated; }
     */

    /**
     * Timestamp when the UI Schema was created (ISO-86001)
     *
     * @return created
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Timestamp when the UI Schema was created (ISO-86001)")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public OffsetDateTime getCreated() {
        return created;
    }

    /**
     * Unique identifier for the UI Schema
     *
     * @return id
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Unique identifier for the UI Schema")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getId() {
        return id;
    }

    /**
     * Timestamp when the UI Schema was last modified (ISO-86001)
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Timestamp when the UI Schema was last modified (ISO-86001)")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public UISchemasResponseObject uiSchema(UISchemaObject uiSchema) {

        this.uiSchema = uiSchema;
        return this;
    }

    /**
     * Get uiSchema
     *
     * @return uiSchema
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_UI_SCHEMA)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public UISchemaObject getUiSchema() {
        return uiSchema;
    }

    @JsonProperty(JSON_PROPERTY_UI_SCHEMA)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setUiSchema(UISchemaObject uiSchema) {
        this.uiSchema = uiSchema;
    }

    public UISchemasResponseObject links(LinksSelf links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public LinksSelf getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UISchemasResponseObject uiSchemasResponseObject = (UISchemasResponseObject) o;
        return Objects.equals(this.created, uiSchemasResponseObject.created)
                && Objects.equals(this.id, uiSchemasResponseObject.id)
                && Objects.equals(this.lastUpdated, uiSchemasResponseObject.lastUpdated)
                && Objects.equals(this.uiSchema, uiSchemasResponseObject.uiSchema)
                && Objects.equals(this.links, uiSchemasResponseObject.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(created, id, lastUpdated, uiSchema, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UISchemasResponseObject {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    uiSchema: ").append(toIndentedString(uiSchema)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
