package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserFactorSMSProfile
 */
@JsonPropertyOrder({ UserFactorSMSProfile.JSON_PROPERTY_PHONE_NUMBER })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class UserFactorSMSProfile implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
    private String phoneNumber;

    public UserFactorSMSProfile() {
    }

    public UserFactorSMSProfile phoneNumber(String phoneNumber) {

        this.phoneNumber = phoneNumber;
        return this;
    }

    /**
     * Phone number of the Factor. You should format phone numbers to use the [E.164
     * standard](https://www.itu.int/rec/T-REC-E.164/).
     *
     * @return phoneNumber
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "+15554151337", value = "Phone number of the Factor. You should format phone numbers to use the [E.164 standard](https://www.itu.int/rec/T-REC-E.164/).")
    @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPhoneNumber() {
        return phoneNumber;
    }

    @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserFactorSMSProfile userFactorSMSProfile = (UserFactorSMSProfile) o;
        return Objects.equals(this.phoneNumber, userFactorSMSProfile.phoneNumber);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(phoneNumber);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactorSMSProfile {\n");
        sb.append("    phoneNumber: ").append(toIndentedString(phoneNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
