package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UserImportRequestData;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserImportRequest
 */
@JsonPropertyOrder({ UserImportRequest.JSON_PROPERTY_DATA, UserImportRequest.JSON_PROPERTY_EVENT_TYPE,
        UserImportRequest.JSON_PROPERTY_SOURCE })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class UserImportRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DATA = "data";
    private UserImportRequestData data;

    public static final String JSON_PROPERTY_EVENT_TYPE = "eventType";
    private String eventType;

    public static final String JSON_PROPERTY_SOURCE = "source";
    private String source;

    public UserImportRequest() {
    }

    public UserImportRequest data(UserImportRequestData data) {

        this.data = data;
        return this;
    }

    /**
     * Get data
     *
     * @return data
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserImportRequestData getData() {
        return data;
    }

    @JsonProperty(JSON_PROPERTY_DATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setData(UserImportRequestData data) {
        this.data = data;
    }

    public UserImportRequest eventType(String eventType) {

        this.eventType = eventType;
        return this;
    }

    /**
     * The type of inline hook. The user import inline hook type is &#x60;com.okta.import.transform&#x60;.
     *
     * @return eventType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The type of inline hook. The user import inline hook type is `com.okta.import.transform`.")
    @JsonProperty(JSON_PROPERTY_EVENT_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getEventType() {
        return eventType;
    }

    @JsonProperty(JSON_PROPERTY_EVENT_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public UserImportRequest source(String source) {

        this.source = source;
        return this;
    }

    /**
     * The ID of the user import inline hook
     *
     * @return source
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The ID of the user import inline hook")
    @JsonProperty(JSON_PROPERTY_SOURCE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getSource() {
        return source;
    }

    @JsonProperty(JSON_PROPERTY_SOURCE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserImportRequest userImportRequest = (UserImportRequest) o;
        return Objects.equals(this.data, userImportRequest.data)
                && Objects.equals(this.eventType, userImportRequest.eventType)
                && Objects.equals(this.source, userImportRequest.source);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(data, eventType, source);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserImportRequest {\n");
        sb.append("    data: ").append(toIndentedString(data)).append("\n");
        sb.append("    eventType: ").append(toIndentedString(eventType)).append("\n");
        sb.append("    source: ").append(toIndentedString(source)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
