package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The app user profile being imported
 */
@ApiModel(description = "The app user profile being imported")
@JsonPropertyOrder({ UserImportRequestDataAppUser.JSON_PROPERTY_PROFILE })
@JsonTypeName("UserImportRequestData_appUser")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class UserImportRequestDataAppUser implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Map<String, String> profile = null;

    public UserImportRequestDataAppUser() {
    }

    public UserImportRequestDataAppUser profile(Map<String, String> profile) {

        this.profile = profile;
        return this;
    }

    public UserImportRequestDataAppUser putprofileItem(String key, String profileItem) {
        if (this.profile == null) {
            this.profile = new HashMap<>();
        }
        this.profile.put(key, profileItem);
        return this;
    }

    /**
     * Provides the name-value pairs of the attributes contained in the app user profile of the user who is being
     * imported. You can change the values of attributes in the user&#39;s app profile by means of the
     * &#x60;commands&#x60; object you return. If you change attributes in the app profile, they then flow through to
     * the Okta user profile, based on matching and mapping rules.
     *
     * @return profile
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Provides the name-value pairs of the attributes contained in the app user profile of the user who is being imported. You can change  the values of attributes in the user's app profile by means of the `commands` object you return. If you change attributes in the app  profile, they then flow through to the Okta user profile, based on matching and mapping rules.")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, String> getProfile() {
        return profile;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(Map<String, String> profile) {
        this.profile = profile;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserImportRequestDataAppUser userImportRequestDataAppUser = (UserImportRequestDataAppUser) o;
        return Objects.equals(this.profile, userImportRequestDataAppUser.profile);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(profile);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserImportRequestDataAppUser {\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
