package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * An object to return an error. Returning an error causes Okta to record a failure event in the Okta System Log. The
 * string supplied in the &#x60;errorSummary&#x60; property is recorded in the System Log event. &gt;**Note:** If a
 * response to an import inline hook request is not received from your external service within three seconds, a timeout
 * occurs. In this scenario, the Okta import process continues and the user is created.
 */
@ApiModel(description = "An object to return an error. Returning an error causes Okta to record a failure event in the Okta System Log.  The string supplied in the `errorSummary` property is recorded in the System Log event.  >**Note:** If a response to an import inline hook request is not received from your external service within three seconds, a timeout occurs. In this scenario, the Okta import process continues and the user is created.")
@JsonPropertyOrder({ UserImportResponseError.JSON_PROPERTY_ERROR_SUMMARY })
@JsonTypeName("UserImportResponse_error")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class UserImportResponseError implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ERROR_SUMMARY = "errorSummary";
    private String errorSummary;

    public UserImportResponseError() {
    }

    public UserImportResponseError errorSummary(String errorSummary) {

        this.errorSummary = errorSummary;
        return this;
    }

    /**
     * A human-readable summary of the error
     *
     * @return errorSummary
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A human-readable summary of the error")
    @JsonProperty(JSON_PROPERTY_ERROR_SUMMARY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getErrorSummary() {
        return errorSummary;
    }

    @JsonProperty(JSON_PROPERTY_ERROR_SUMMARY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setErrorSummary(String errorSummary) {
        this.errorSummary = errorSummary;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserImportResponseError userImportResponseError = (UserImportResponseError) o;
        return Objects.equals(this.errorSummary, userImportResponseError.errorSummary);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(errorSummary);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserImportResponseError {\n");
        sb.append("    errorSummary: ").append(toIndentedString(errorSummary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
