package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * WsFederationApplicationSettingsApplication
 */
@JsonPropertyOrder({ WsFederationApplicationSettingsApplication.JSON_PROPERTY_ATTRIBUTE_STATEMENTS,
        WsFederationApplicationSettingsApplication.JSON_PROPERTY_AUDIENCE_RESTRICTION,
        WsFederationApplicationSettingsApplication.JSON_PROPERTY_AUTHN_CONTEXT_CLASS_REF,
        WsFederationApplicationSettingsApplication.JSON_PROPERTY_GROUP_FILTER,
        WsFederationApplicationSettingsApplication.JSON_PROPERTY_GROUP_NAME,
        WsFederationApplicationSettingsApplication.JSON_PROPERTY_GROUP_VALUE_FORMAT,
        WsFederationApplicationSettingsApplication.JSON_PROPERTY_NAME_I_D_FORMAT,
        WsFederationApplicationSettingsApplication.JSON_PROPERTY_REALM,
        WsFederationApplicationSettingsApplication.JSON_PROPERTY_SITE_U_R_L,
        WsFederationApplicationSettingsApplication.JSON_PROPERTY_USERNAME_ATTRIBUTE,
        WsFederationApplicationSettingsApplication.JSON_PROPERTY_W_REPLY_OVERRIDE,
        WsFederationApplicationSettingsApplication.JSON_PROPERTY_W_REPLY_U_R_L })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class WsFederationApplicationSettingsApplication implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ATTRIBUTE_STATEMENTS = "attributeStatements";
    private String attributeStatements;

    public static final String JSON_PROPERTY_AUDIENCE_RESTRICTION = "audienceRestriction";
    private String audienceRestriction;

    public static final String JSON_PROPERTY_AUTHN_CONTEXT_CLASS_REF = "authnContextClassRef";
    private String authnContextClassRef;

    public static final String JSON_PROPERTY_GROUP_FILTER = "groupFilter";
    private String groupFilter;

    public static final String JSON_PROPERTY_GROUP_NAME = "groupName";
    private String groupName;

    /**
     * Specifies the WS-Fed assertion attribute value for filtered groups. This attribute is only applied to Active
     * Directory groups.
     */
    public enum GroupValueFormatEnum {
        WINDOWS_DOMAIN_QUALIFIED_NAME("windowsDomainQualifiedName"),

        SAM_ACCOUNT_NAME("samAccountName"),

        DN("dn"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        GroupValueFormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static GroupValueFormatEnum fromValue(String value) {
            for (GroupValueFormatEnum b : GroupValueFormatEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_GROUP_VALUE_FORMAT = "groupValueFormat";
    private GroupValueFormatEnum groupValueFormat;

    public static final String JSON_PROPERTY_NAME_I_D_FORMAT = "nameIDFormat";
    private String nameIDFormat;

    public static final String JSON_PROPERTY_REALM = "realm";
    private String realm;

    public static final String JSON_PROPERTY_SITE_U_R_L = "siteURL";
    private String siteURL;

    /**
     * Specifies additional username attribute statements to include in the WS-Fed assertion
     */
    public enum UsernameAttributeEnum {
        USERNAME("username"),

        UPN("upn"),

        UPN_AND_USERNAME("upnAndUsername"),

        NONE("none"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        UsernameAttributeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static UsernameAttributeEnum fromValue(String value) {
            for (UsernameAttributeEnum b : UsernameAttributeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_USERNAME_ATTRIBUTE = "usernameAttribute";
    private UsernameAttributeEnum usernameAttribute;

    public static final String JSON_PROPERTY_W_REPLY_OVERRIDE = "wReplyOverride";
    private Boolean wReplyOverride;

    public static final String JSON_PROPERTY_W_REPLY_U_R_L = "wReplyURL";
    private String wReplyURL;

    public WsFederationApplicationSettingsApplication() {
    }

    public WsFederationApplicationSettingsApplication attributeStatements(String attributeStatements) {

        this.attributeStatements = attributeStatements;
        return this;
    }

    /**
     * You can federate user attributes such as Okta profile fields, LDAP, Active Directory, and Workday values. The SP
     * uses the federated WS-Fed attribute values accordingly.
     *
     * @return attributeStatements
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "You can federate user attributes such as Okta profile fields, LDAP, Active Directory, and Workday values. The SP uses the federated WS-Fed attribute values accordingly.")
    @JsonProperty(JSON_PROPERTY_ATTRIBUTE_STATEMENTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAttributeStatements() {
        return attributeStatements;
    }

    @JsonProperty(JSON_PROPERTY_ATTRIBUTE_STATEMENTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAttributeStatements(String attributeStatements) {
        this.attributeStatements = attributeStatements;
    }

    public WsFederationApplicationSettingsApplication audienceRestriction(String audienceRestriction) {

        this.audienceRestriction = audienceRestriction;
        return this;
    }

    /**
     * The entity ID of the SP. Use the entity ID value exactly as provided by the SP.
     *
     * @return audienceRestriction
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "The entity ID of the SP. Use the entity ID value exactly as provided by the SP.")
    @JsonProperty(JSON_PROPERTY_AUDIENCE_RESTRICTION)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getAudienceRestriction() {
        return audienceRestriction;
    }

    @JsonProperty(JSON_PROPERTY_AUDIENCE_RESTRICTION)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setAudienceRestriction(String audienceRestriction) {
        this.audienceRestriction = audienceRestriction;
    }

    public WsFederationApplicationSettingsApplication authnContextClassRef(String authnContextClassRef) {

        this.authnContextClassRef = authnContextClassRef;
        return this;
    }

    /**
     * Identifies the SAML authentication context class for the assertion&#39;s authentication statement
     *
     * @return authnContextClassRef
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Identifies the SAML authentication context class for the assertion's authentication statement")
    @JsonProperty(JSON_PROPERTY_AUTHN_CONTEXT_CLASS_REF)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getAuthnContextClassRef() {
        return authnContextClassRef;
    }

    @JsonProperty(JSON_PROPERTY_AUTHN_CONTEXT_CLASS_REF)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setAuthnContextClassRef(String authnContextClassRef) {
        this.authnContextClassRef = authnContextClassRef;
    }

    public WsFederationApplicationSettingsApplication groupFilter(String groupFilter) {

        this.groupFilter = groupFilter;
        return this;
    }

    /**
     * A regular expression that filters for the User Groups you want included with the &#x60;groupName&#x60; attribute.
     * If the matching User Group has a corresponding AD group, then the attribute statement includes the value of the
     * attribute specified by &#x60;groupValueFormat&#x60;. If the matching User Group doesn&#39;t contain a
     * corresponding AD group, then the &#x60;groupName&#x60; is used in the attribute statement.
     *
     * @return groupFilter
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A regular expression that filters for the User Groups you want included with the `groupName` attribute. If the matching User Group has a corresponding AD group, then the attribute statement includes the value of the attribute specified by `groupValueFormat`. If the matching User Group doesn't contain a corresponding AD group, then the `groupName` is used in the attribute statement.")
    @JsonProperty(JSON_PROPERTY_GROUP_FILTER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getGroupFilter() {
        return groupFilter;
    }

    @JsonProperty(JSON_PROPERTY_GROUP_FILTER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGroupFilter(String groupFilter) {
        this.groupFilter = groupFilter;
    }

    public WsFederationApplicationSettingsApplication groupName(String groupName) {

        this.groupName = groupName;
        return this;
    }

    /**
     * The group name to include in the WS-Fed response attribute statement. This property is used in conjunction with
     * the &#x60;groupFilter&#x60; property. Groups that are filtered through the &#x60;groupFilter&#x60; expression are
     * included with the &#x60;groupName&#x60; in the attribute statement. Any users that belong to the group you&#39;ve
     * filtered are included in the WS-Fed response attribute statement.
     *
     * @return groupName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The group name to include in the WS-Fed response attribute statement. This property is used in conjunction with the `groupFilter` property.  Groups that are filtered through the `groupFilter` expression are included with the `groupName` in the attribute statement. Any users that belong to the group you've filtered are included in the WS-Fed response attribute statement.")
    @JsonProperty(JSON_PROPERTY_GROUP_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getGroupName() {
        return groupName;
    }

    @JsonProperty(JSON_PROPERTY_GROUP_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public WsFederationApplicationSettingsApplication groupValueFormat(GroupValueFormatEnum groupValueFormat) {

        this.groupValueFormat = groupValueFormat;
        return this;
    }

    /**
     * Specifies the WS-Fed assertion attribute value for filtered groups. This attribute is only applied to Active
     * Directory groups.
     *
     * @return groupValueFormat
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Specifies the WS-Fed assertion attribute value for filtered groups. This attribute is only applied to Active Directory groups.")
    @JsonProperty(JSON_PROPERTY_GROUP_VALUE_FORMAT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public GroupValueFormatEnum getGroupValueFormat() {
        return groupValueFormat;
    }

    @JsonProperty(JSON_PROPERTY_GROUP_VALUE_FORMAT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setGroupValueFormat(GroupValueFormatEnum groupValueFormat) {
        this.groupValueFormat = groupValueFormat;
    }

    public WsFederationApplicationSettingsApplication nameIDFormat(String nameIDFormat) {

        this.nameIDFormat = nameIDFormat;
        return this;
    }

    /**
     * The username format that you send in the WS-Fed response
     *
     * @return nameIDFormat
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "The username format that you send in the WS-Fed response")
    @JsonProperty(JSON_PROPERTY_NAME_I_D_FORMAT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getNameIDFormat() {
        return nameIDFormat;
    }

    @JsonProperty(JSON_PROPERTY_NAME_I_D_FORMAT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setNameIDFormat(String nameIDFormat) {
        this.nameIDFormat = nameIDFormat;
    }

    public WsFederationApplicationSettingsApplication realm(String realm) {

        this.realm = realm;
        return this;
    }

    /**
     * The uniform resource identifier (URI) of the WS-Fed app that&#39;s used to share resources securely within a
     * domain. It&#39;s the identity that&#39;s sent to the Okta IdP when signing in. See [Realm
     * name](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;ext_Apps_Configure_Okta_Template_WS_Federation#Realm).
     *
     * @return realm
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The uniform resource identifier (URI) of the WS-Fed app that's used to share resources securely within a domain. It's the identity that's sent to the Okta IdP when signing in. See [Realm name](https://help.okta.com/okta_help.htm?type=oie&id=ext_Apps_Configure_Okta_Template_WS_Federation#Realm).")
    @JsonProperty(JSON_PROPERTY_REALM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getRealm() {
        return realm;
    }

    @JsonProperty(JSON_PROPERTY_REALM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRealm(String realm) {
        this.realm = realm;
    }

    public WsFederationApplicationSettingsApplication siteURL(String siteURL) {

        this.siteURL = siteURL;
        return this;
    }

    /**
     * Launch URL for the web app
     *
     * @return siteURL
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Launch URL for the web app")
    @JsonProperty(JSON_PROPERTY_SITE_U_R_L)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getSiteURL() {
        return siteURL;
    }

    @JsonProperty(JSON_PROPERTY_SITE_U_R_L)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setSiteURL(String siteURL) {
        this.siteURL = siteURL;
    }

    public WsFederationApplicationSettingsApplication usernameAttribute(UsernameAttributeEnum usernameAttribute) {

        this.usernameAttribute = usernameAttribute;
        return this;
    }

    /**
     * Specifies additional username attribute statements to include in the WS-Fed assertion
     *
     * @return usernameAttribute
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Specifies additional username attribute statements to include in the WS-Fed assertion")
    @JsonProperty(JSON_PROPERTY_USERNAME_ATTRIBUTE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public UsernameAttributeEnum getUsernameAttribute() {
        return usernameAttribute;
    }

    @JsonProperty(JSON_PROPERTY_USERNAME_ATTRIBUTE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setUsernameAttribute(UsernameAttributeEnum usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
    }

    public WsFederationApplicationSettingsApplication wReplyOverride(Boolean wReplyOverride) {

        this.wReplyOverride = wReplyOverride;
        return this;
    }

    /**
     * Enables a web app to override the &#x60;wReplyURL&#x60; URL with a reply parameter.
     *
     * @return wReplyOverride
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Enables a web app to override the `wReplyURL` URL with a reply parameter.")
    @JsonProperty(JSON_PROPERTY_W_REPLY_OVERRIDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getwReplyOverride() {
        return wReplyOverride;
    }

    @JsonProperty(JSON_PROPERTY_W_REPLY_OVERRIDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setwReplyOverride(Boolean wReplyOverride) {
        this.wReplyOverride = wReplyOverride;
    }

    public WsFederationApplicationSettingsApplication wReplyURL(String wReplyURL) {

        this.wReplyURL = wReplyURL;
        return this;
    }

    /**
     * The WS-Fed SP endpoint where your users sign in
     *
     * @return wReplyURL
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "http://test.acme.com/example-post-sign/", required = true, value = "The WS-Fed SP endpoint where your users sign in")
    @JsonProperty(JSON_PROPERTY_W_REPLY_U_R_L)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getwReplyURL() {
        return wReplyURL;
    }

    @JsonProperty(JSON_PROPERTY_W_REPLY_U_R_L)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setwReplyURL(String wReplyURL) {
        this.wReplyURL = wReplyURL;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WsFederationApplicationSettingsApplication wsFederationApplicationSettingsApplication = (WsFederationApplicationSettingsApplication) o;
        return Objects.equals(this.attributeStatements, wsFederationApplicationSettingsApplication.attributeStatements)
                && Objects.equals(this.audienceRestriction,
                        wsFederationApplicationSettingsApplication.audienceRestriction)
                && Objects.equals(this.authnContextClassRef,
                        wsFederationApplicationSettingsApplication.authnContextClassRef)
                && Objects.equals(this.groupFilter, wsFederationApplicationSettingsApplication.groupFilter)
                && Objects.equals(this.groupName, wsFederationApplicationSettingsApplication.groupName)
                && Objects.equals(this.groupValueFormat, wsFederationApplicationSettingsApplication.groupValueFormat)
                && Objects.equals(this.nameIDFormat, wsFederationApplicationSettingsApplication.nameIDFormat)
                && Objects.equals(this.realm, wsFederationApplicationSettingsApplication.realm)
                && Objects.equals(this.siteURL, wsFederationApplicationSettingsApplication.siteURL)
                && Objects.equals(this.usernameAttribute, wsFederationApplicationSettingsApplication.usernameAttribute)
                && Objects.equals(this.wReplyOverride, wsFederationApplicationSettingsApplication.wReplyOverride)
                && Objects.equals(this.wReplyURL, wsFederationApplicationSettingsApplication.wReplyURL);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(attributeStatements, audienceRestriction, authnContextClassRef, groupFilter, groupName,
                groupValueFormat, nameIDFormat, realm, siteURL, usernameAttribute, wReplyOverride, wReplyURL);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WsFederationApplicationSettingsApplication {\n");
        sb.append("    attributeStatements: ").append(toIndentedString(attributeStatements)).append("\n");
        sb.append("    audienceRestriction: ").append(toIndentedString(audienceRestriction)).append("\n");
        sb.append("    authnContextClassRef: ").append(toIndentedString(authnContextClassRef)).append("\n");
        sb.append("    groupFilter: ").append(toIndentedString(groupFilter)).append("\n");
        sb.append("    groupName: ").append(toIndentedString(groupName)).append("\n");
        sb.append("    groupValueFormat: ").append(toIndentedString(groupValueFormat)).append("\n");
        sb.append("    nameIDFormat: ").append(toIndentedString(nameIDFormat)).append("\n");
        sb.append("    realm: ").append(toIndentedString(realm)).append("\n");
        sb.append("    siteURL: ").append(toIndentedString(siteURL)).append("\n");
        sb.append("    usernameAttribute: ").append(toIndentedString(usernameAttribute)).append("\n");
        sb.append("    wReplyOverride: ").append(toIndentedString(wReplyOverride)).append("\n");
        sb.append("    wReplyURL: ").append(toIndentedString(wReplyURL)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
