/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.BehaviorRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class BehaviorApi {
    private ApiClient apiClient;

    public BehaviorApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BehaviorApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public BehaviorRule activateBehaviorDetectionRule(String behaviorId) throws ApiException {
        return this.activateBehaviorDetectionRule(behaviorId, Collections.emptyMap());
    }

    public BehaviorRule activateBehaviorDetectionRule(String behaviorId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (behaviorId == null) {
            throw new ApiException(400, "Missing the required parameter 'behaviorId' when calling activateBehaviorDetectionRule");
        }
        String localVarPath = "/api/v1/behaviors/{behaviorId}/lifecycle/activate".replaceAll("\\{behaviorId\\}", this.apiClient.escapeString(behaviorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<BehaviorRule> localVarReturnType = new TypeReference<BehaviorRule>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BehaviorRule createBehaviorDetectionRule(BehaviorRule rule) throws ApiException {
        return this.createBehaviorDetectionRule(rule, Collections.emptyMap());
    }

    public BehaviorRule createBehaviorDetectionRule(BehaviorRule rule, Map<String, String> additionalHeaders) throws ApiException {
        BehaviorRule localVarPostBody = rule;
        if (rule == null) {
            throw new ApiException(400, "Missing the required parameter 'rule' when calling createBehaviorDetectionRule");
        }
        String localVarPath = "/api/v1/behaviors";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<BehaviorRule> localVarReturnType = new TypeReference<BehaviorRule>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BehaviorRule deactivateBehaviorDetectionRule(String behaviorId) throws ApiException {
        return this.deactivateBehaviorDetectionRule(behaviorId, Collections.emptyMap());
    }

    public BehaviorRule deactivateBehaviorDetectionRule(String behaviorId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (behaviorId == null) {
            throw new ApiException(400, "Missing the required parameter 'behaviorId' when calling deactivateBehaviorDetectionRule");
        }
        String localVarPath = "/api/v1/behaviors/{behaviorId}/lifecycle/deactivate".replaceAll("\\{behaviorId\\}", this.apiClient.escapeString(behaviorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<BehaviorRule> localVarReturnType = new TypeReference<BehaviorRule>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteBehaviorDetectionRule(String behaviorId) throws ApiException {
        this.deleteBehaviorDetectionRule(behaviorId, Collections.emptyMap());
    }

    public void deleteBehaviorDetectionRule(String behaviorId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (behaviorId == null) {
            throw new ApiException(400, "Missing the required parameter 'behaviorId' when calling deleteBehaviorDetectionRule");
        }
        String localVarPath = "/api/v1/behaviors/{behaviorId}".replaceAll("\\{behaviorId\\}", this.apiClient.escapeString(behaviorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public BehaviorRule getBehaviorDetectionRule(String behaviorId) throws ApiException {
        return this.getBehaviorDetectionRule(behaviorId, Collections.emptyMap());
    }

    public BehaviorRule getBehaviorDetectionRule(String behaviorId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (behaviorId == null) {
            throw new ApiException(400, "Missing the required parameter 'behaviorId' when calling getBehaviorDetectionRule");
        }
        String localVarPath = "/api/v1/behaviors/{behaviorId}".replaceAll("\\{behaviorId\\}", this.apiClient.escapeString(behaviorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<BehaviorRule> localVarReturnType = new TypeReference<BehaviorRule>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<BehaviorRule> listBehaviorDetectionRules() throws ApiException {
        return this.listBehaviorDetectionRules(Collections.emptyMap());
    }

    public List<BehaviorRule> listBehaviorDetectionRules(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/behaviors";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<BehaviorRule>> localVarReturnType = new TypeReference<List<BehaviorRule>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BehaviorRule replaceBehaviorDetectionRule(String behaviorId, BehaviorRule rule) throws ApiException {
        return this.replaceBehaviorDetectionRule(behaviorId, rule, Collections.emptyMap());
    }

    public BehaviorRule replaceBehaviorDetectionRule(String behaviorId, BehaviorRule rule, Map<String, String> additionalHeaders) throws ApiException {
        BehaviorRule localVarPostBody = rule;
        if (behaviorId == null) {
            throw new ApiException(400, "Missing the required parameter 'behaviorId' when calling replaceBehaviorDetectionRule");
        }
        if (rule == null) {
            throw new ApiException(400, "Missing the required parameter 'rule' when calling replaceBehaviorDetectionRule");
        }
        String localVarPath = "/api/v1/behaviors/{behaviorId}".replaceAll("\\{behaviorId\\}", this.apiClient.escapeString(behaviorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<BehaviorRule> localVarReturnType = new TypeReference<BehaviorRule>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

