/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.AssignRoleToGroupRequest;
import com.okta.sdk.resource.model.ListGroupAssignedRoles200ResponseInner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class RoleAssignmentBGroupApi {
    private ApiClient apiClient;

    public RoleAssignmentBGroupApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleAssignmentBGroupApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ListGroupAssignedRoles200ResponseInner assignRoleToGroup(String groupId, AssignRoleToGroupRequest assignRoleRequest, Boolean disableNotifications) throws ApiException {
        return this.assignRoleToGroup(groupId, assignRoleRequest, disableNotifications, Collections.emptyMap());
    }

    public ListGroupAssignedRoles200ResponseInner assignRoleToGroup(String groupId, AssignRoleToGroupRequest assignRoleRequest, Boolean disableNotifications, Map<String, String> additionalHeaders) throws ApiException {
        AssignRoleToGroupRequest localVarPostBody = assignRoleRequest;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling assignRoleToGroup");
        }
        if (assignRoleRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'assignRoleRequest' when calling assignRoleToGroup");
        }
        String localVarPath = "/api/v1/groups/{groupId}/roles".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("disableNotifications", disableNotifications));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ListGroupAssignedRoles200ResponseInner> localVarReturnType = new TypeReference<ListGroupAssignedRoles200ResponseInner>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ListGroupAssignedRoles200ResponseInner getGroupAssignedRole(String groupId, String roleAssignmentId) throws ApiException {
        return this.getGroupAssignedRole(groupId, roleAssignmentId, Collections.emptyMap());
    }

    public ListGroupAssignedRoles200ResponseInner getGroupAssignedRole(String groupId, String roleAssignmentId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling getGroupAssignedRole");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling getGroupAssignedRole");
        }
        String localVarPath = "/api/v1/groups/{groupId}/roles/{roleAssignmentId}".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ListGroupAssignedRoles200ResponseInner> localVarReturnType = new TypeReference<ListGroupAssignedRoles200ResponseInner>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ListGroupAssignedRoles200ResponseInner> listGroupAssignedRoles(String groupId, String expand) throws ApiException {
        return this.listGroupAssignedRoles(groupId, expand, Collections.emptyMap());
    }

    public List<ListGroupAssignedRoles200ResponseInner> listGroupAssignedRoles(String groupId, String expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling listGroupAssignedRoles");
        }
        String localVarPath = "/api/v1/groups/{groupId}/roles".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<ListGroupAssignedRoles200ResponseInner>> localVarReturnType = new TypeReference<List<ListGroupAssignedRoles200ResponseInner>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void unassignRoleFromGroup(String groupId, String roleAssignmentId) throws ApiException {
        this.unassignRoleFromGroup(groupId, roleAssignmentId, Collections.emptyMap());
    }

    public void unassignRoleFromGroup(String groupId, String roleAssignmentId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling unassignRoleFromGroup");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling unassignRoleFromGroup");
        }
        String localVarPath = "/api/v1/groups/{groupId}/roles/{roleAssignmentId}".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

