/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.AccessPolicyLink;
import com.okta.sdk.resource.model.GroupsLink;
import com.okta.sdk.resource.model.HelpLink;
import com.okta.sdk.resource.model.HrefObject;
import com.okta.sdk.resource.model.HrefObjectActivateLink;
import com.okta.sdk.resource.model.HrefObjectDeactivateLink;
import com.okta.sdk.resource.model.HrefObjectSelfLink;
import com.okta.sdk.resource.model.MetadataLink;
import com.okta.sdk.resource.model.UsersLink;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Discoverable resources related to the app")
@JsonPropertyOrder(value={"accessPolicy", "activate", "appLinks", "deactivate", "groups", "help", "logo", "metadata", "self", "users"})
public class ApplicationLinks
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ACCESS_POLICY = "accessPolicy";
    private AccessPolicyLink accessPolicy;
    public static final String JSON_PROPERTY_ACTIVATE = "activate";
    private HrefObjectActivateLink activate;
    public static final String JSON_PROPERTY_APP_LINKS = "appLinks";
    private List<HrefObject> appLinks = null;
    public static final String JSON_PROPERTY_DEACTIVATE = "deactivate";
    private HrefObjectDeactivateLink deactivate;
    public static final String JSON_PROPERTY_GROUPS = "groups";
    private GroupsLink groups;
    public static final String JSON_PROPERTY_HELP = "help";
    private HelpLink help;
    public static final String JSON_PROPERTY_LOGO = "logo";
    private List<HrefObject> logo = null;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private MetadataLink metadata;
    public static final String JSON_PROPERTY_SELF = "self";
    private HrefObjectSelfLink self;
    public static final String JSON_PROPERTY_USERS = "users";
    private UsersLink users;

    public ApplicationLinks accessPolicy(AccessPolicyLink accessPolicy) {
        this.accessPolicy = accessPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="accessPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccessPolicyLink getAccessPolicy() {
        return this.accessPolicy;
    }

    @JsonProperty(value="accessPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccessPolicy(AccessPolicyLink accessPolicy) {
        this.accessPolicy = accessPolicy;
    }

    public ApplicationLinks activate(HrefObjectActivateLink activate) {
        this.activate = activate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="activate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObjectActivateLink getActivate() {
        return this.activate;
    }

    @JsonProperty(value="activate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActivate(HrefObjectActivateLink activate) {
        this.activate = activate;
    }

    public ApplicationLinks appLinks(List<HrefObject> appLinks) {
        this.appLinks = appLinks;
        return this;
    }

    public ApplicationLinks addappLinksItem(HrefObject appLinksItem) {
        if (this.appLinks == null) {
            this.appLinks = new ArrayList<HrefObject>();
        }
        this.appLinks.add(appLinksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of app link resources")
    @JsonProperty(value="appLinks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<HrefObject> getAppLinks() {
        return this.appLinks;
    }

    @JsonProperty(value="appLinks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAppLinks(List<HrefObject> appLinks) {
        this.appLinks = appLinks;
    }

    public ApplicationLinks deactivate(HrefObjectDeactivateLink deactivate) {
        this.deactivate = deactivate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="deactivate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObjectDeactivateLink getDeactivate() {
        return this.deactivate;
    }

    @JsonProperty(value="deactivate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeactivate(HrefObjectDeactivateLink deactivate) {
        this.deactivate = deactivate;
    }

    public ApplicationLinks groups(GroupsLink groups) {
        this.groups = groups;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GroupsLink getGroups() {
        return this.groups;
    }

    @JsonProperty(value="groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroups(GroupsLink groups) {
        this.groups = groups;
    }

    public ApplicationLinks help(HelpLink help) {
        this.help = help;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="help")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HelpLink getHelp() {
        return this.help;
    }

    @JsonProperty(value="help")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHelp(HelpLink help) {
        this.help = help;
    }

    public ApplicationLinks logo(List<HrefObject> logo) {
        this.logo = logo;
        return this;
    }

    public ApplicationLinks addlogoItem(HrefObject logoItem) {
        if (this.logo == null) {
            this.logo = new ArrayList<HrefObject>();
        }
        this.logo.add(logoItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of app logo resources")
    @JsonProperty(value="logo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<HrefObject> getLogo() {
        return this.logo;
    }

    @JsonProperty(value="logo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogo(List<HrefObject> logo) {
        this.logo = logo;
    }

    public ApplicationLinks metadata(MetadataLink metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MetadataLink getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(MetadataLink metadata) {
        this.metadata = metadata;
    }

    public ApplicationLinks self(HrefObjectSelfLink self) {
        this.self = self;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="self")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObjectSelfLink getSelf() {
        return this.self;
    }

    @JsonProperty(value="self")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelf(HrefObjectSelfLink self) {
        this.self = self;
    }

    public ApplicationLinks users(UsersLink users) {
        this.users = users;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="users")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UsersLink getUsers() {
        return this.users;
    }

    @JsonProperty(value="users")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsers(UsersLink users) {
        this.users = users;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationLinks applicationLinks = (ApplicationLinks)o;
        return Objects.equals(this.accessPolicy, applicationLinks.accessPolicy) && Objects.equals(this.activate, applicationLinks.activate) && Objects.equals(this.appLinks, applicationLinks.appLinks) && Objects.equals(this.deactivate, applicationLinks.deactivate) && Objects.equals(this.groups, applicationLinks.groups) && Objects.equals(this.help, applicationLinks.help) && Objects.equals(this.logo, applicationLinks.logo) && Objects.equals(this.metadata, applicationLinks.metadata) && Objects.equals(this.self, applicationLinks.self) && Objects.equals(this.users, applicationLinks.users);
    }

    public int hashCode() {
        return Objects.hash(this.accessPolicy, this.activate, this.appLinks, this.deactivate, this.groups, this.help, this.logo, this.metadata, this.self, this.users);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationLinks {\n");
        sb.append("    accessPolicy: ").append(this.toIndentedString(this.accessPolicy)).append("\n");
        sb.append("    activate: ").append(this.toIndentedString(this.activate)).append("\n");
        sb.append("    appLinks: ").append(this.toIndentedString(this.appLinks)).append("\n");
        sb.append("    deactivate: ").append(this.toIndentedString(this.deactivate)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    help: ").append(this.toIndentedString(this.help)).append("\n");
        sb.append("    logo: ").append(this.toIndentedString(this.logo)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    users: ").append(this.toIndentedString(this.users)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

