/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines network zones for VPN notification")
@JsonPropertyOrder(value={"connection", "exclude", "include"})
public class ApplicationSettingsNotificationsVpnNetwork
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CONNECTION = "connection";
    private ConnectionEnum connection;
    public static final String JSON_PROPERTY_EXCLUDE = "exclude";
    private List<String> exclude = null;
    public static final String JSON_PROPERTY_INCLUDE = "include";
    private List<String> include = null;

    public ApplicationSettingsNotificationsVpnNetwork connection(ConnectionEnum connection) {
        this.connection = connection;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the VPN connection details required to access the app")
    @JsonProperty(value="connection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConnectionEnum getConnection() {
        return this.connection;
    }

    @JsonProperty(value="connection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConnection(ConnectionEnum connection) {
        this.connection = connection;
    }

    public ApplicationSettingsNotificationsVpnNetwork exclude(List<String> exclude) {
        this.exclude = exclude;
        return this;
    }

    public ApplicationSettingsNotificationsVpnNetwork addexcludeItem(String excludeItem) {
        if (this.exclude == null) {
            this.exclude = new ArrayList<String>();
        }
        this.exclude.add(excludeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Defines the IP addresses or network ranges that are excluded from the VPN requirement")
    @JsonProperty(value="exclude")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getExclude() {
        return this.exclude;
    }

    @JsonProperty(value="exclude")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExclude(List<String> exclude) {
        this.exclude = exclude;
    }

    public ApplicationSettingsNotificationsVpnNetwork include(List<String> include) {
        this.include = include;
        return this;
    }

    public ApplicationSettingsNotificationsVpnNetwork addincludeItem(String includeItem) {
        if (this.include == null) {
            this.include = new ArrayList<String>();
        }
        this.include.add(includeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Defines the IP addresses or network ranges that are required to use the VPN")
    @JsonProperty(value="include")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getInclude() {
        return this.include;
    }

    @JsonProperty(value="include")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInclude(List<String> include) {
        this.include = include;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationSettingsNotificationsVpnNetwork applicationSettingsNotificationsVpnNetwork = (ApplicationSettingsNotificationsVpnNetwork)o;
        return Objects.equals((Object)this.connection, (Object)applicationSettingsNotificationsVpnNetwork.connection) && Objects.equals(this.exclude, applicationSettingsNotificationsVpnNetwork.exclude) && Objects.equals(this.include, applicationSettingsNotificationsVpnNetwork.include);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.connection, this.exclude, this.include});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationSettingsNotificationsVpnNetwork {\n");
        sb.append("    connection: ").append(this.toIndentedString((Object)this.connection)).append("\n");
        sb.append("    exclude: ").append(this.toIndentedString(this.exclude)).append("\n");
        sb.append("    include: ").append(this.toIndentedString(this.include)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ConnectionEnum {
        DISABLED("DISABLED"),
        ANYWHERE("ANYWHERE"),
        ON_NETWORK("ON_NETWORK"),
        OFF_NETWORK("OFF_NETWORK"),
        ZONE("ZONE"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ConnectionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ConnectionEnum fromValue(String value) {
            for (ConnectionEnum b : ConnectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

