/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.okta.sdk.resource.model.HrefObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for the current status of the user. These links are used to discover what groups the user is a part of and what factors they have enrolled.")
@JsonPropertyOrder(value={"groups", "factors"})
@JsonTypeName(value="BaseContext_user__links")
public class BaseContextUserLinks
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_GROUPS = "groups";
    private HrefObject groups;
    public static final String JSON_PROPERTY_FACTORS = "factors";
    private HrefObject factors;

    public BaseContextUserLinks groups(HrefObject groups) {
        this.groups = groups;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to retrieve the individual user's group memberships")
    @JsonProperty(value="groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getGroups() {
        return this.groups;
    }

    @JsonProperty(value="groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroups(HrefObject groups) {
        this.groups = groups;
    }

    public BaseContextUserLinks factors(HrefObject factors) {
        this.factors = factors;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to retrieve individual user's factor enrollments")
    @JsonProperty(value="factors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HrefObject getFactors() {
        return this.factors;
    }

    @JsonProperty(value="factors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFactors(HrefObject factors) {
        this.factors = factors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseContextUserLinks baseContextUserLinks = (BaseContextUserLinks)o;
        return Objects.equals(this.groups, baseContextUserLinks.groups) && Objects.equals(this.factors, baseContextUserLinks.factors);
    }

    public int hashCode() {
        return Objects.hash(this.groups, this.factors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseContextUserLinks {\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    factors: ").append(this.toIndentedString(this.factors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

