/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="\"A user agent is software (a software agent) that is acting on behalf of a user.\" ([Definition of User Agent](https://developer.mozilla.org/en-US/docs/Glossary/User_agent))  In the Okta event data object, the `UserAgent` object provides specifications about the client software that makes event-triggering HTTP requests. User agent identification is often useful for identifying interoperability problems between servers and clients, and also for browser and operating system usage analytics. ")
@JsonPropertyOrder(value={"browser", "os", "rawUserAgent"})
public class LogUserAgent
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_BROWSER = "browser";
    private String browser;
    public static final String JSON_PROPERTY_OS = "os";
    private String os;
    public static final String JSON_PROPERTY_RAW_USER_AGENT = "rawUserAgent";
    private String rawUserAgent;

    @Nullable
    @ApiModelProperty(value="If the client is a web browser, this field identifies the type of web browser (for example, CHROME, FIREFOX)")
    @JsonProperty(value="browser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBrowser() {
        return this.browser;
    }

    @Nullable
    @ApiModelProperty(value="The operating system that the client runs on (for example, Windows 10)")
    @JsonProperty(value="os")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOs() {
        return this.os;
    }

    @Nullable
    @ApiModelProperty(value="A raw string representation of the user agent that is formatted according to [section 5.5.3 of HTTP/1.1 Semantics and Content](https://datatracker.ietf.org/doc/html/rfc7231#section-5.5.3). Both the `browser` and the `OS` fields can be derived from this field.")
    @JsonProperty(value="rawUserAgent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRawUserAgent() {
        return this.rawUserAgent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogUserAgent logUserAgent = (LogUserAgent)o;
        return Objects.equals(this.browser, logUserAgent.browser) && Objects.equals(this.os, logUserAgent.os) && Objects.equals(this.rawUserAgent, logUserAgent.rawUserAgent);
    }

    public int hashCode() {
        return Objects.hash(this.browser, this.os, this.rawUserAgent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogUserAgent {\n");
        sb.append("    browser: ").append(this.toIndentedString(this.browser)).append("\n");
        sb.append("    os: ").append(this.toIndentedString(this.os)).append("\n");
        sb.append("    rawUserAgent: ").append(this.toIndentedString(this.rawUserAgent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

