/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.ApplicationAccessibility;
import com.okta.sdk.resource.model.ApplicationLicensing;
import com.okta.sdk.resource.model.ApplicationLifecycleStatus;
import com.okta.sdk.resource.model.ApplicationVisibility;
import com.okta.sdk.resource.model.SchemeApplicationCredentials;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"accessibility", "credentials", "label", "licensing", "name", "profile", "signOnMode", "status", "visibility"})
public class OINApplication
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ACCESSIBILITY = "accessibility";
    private ApplicationAccessibility accessibility;
    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private SchemeApplicationCredentials credentials;
    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;
    public static final String JSON_PROPERTY_LICENSING = "licensing";
    private ApplicationLicensing licensing;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Map<String, Object> profile = null;
    public static final String JSON_PROPERTY_SIGN_ON_MODE = "signOnMode";
    private String signOnMode;
    public static final String JSON_PROPERTY_STATUS = "status";
    private ApplicationLifecycleStatus status;
    public static final String JSON_PROPERTY_VISIBILITY = "visibility";
    private ApplicationVisibility visibility;

    public OINApplication accessibility(ApplicationAccessibility accessibility) {
        this.accessibility = accessibility;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="accessibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationAccessibility getAccessibility() {
        return this.accessibility;
    }

    @JsonProperty(value="accessibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccessibility(ApplicationAccessibility accessibility) {
        this.accessibility = accessibility;
    }

    public OINApplication credentials(SchemeApplicationCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SchemeApplicationCredentials getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(SchemeApplicationCredentials credentials) {
        this.credentials = credentials;
    }

    public OINApplication label(String label) {
        this.label = label;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="User-defined display name for app")
    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLabel(String label) {
        this.label = label;
    }

    public OINApplication licensing(ApplicationLicensing licensing) {
        this.licensing = licensing;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="licensing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationLicensing getLicensing() {
        return this.licensing;
    }

    @JsonProperty(value="licensing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLicensing(ApplicationLicensing licensing) {
        this.licensing = licensing;
    }

    public OINApplication name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key name for the OIN app definition")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public OINApplication profile(Map<String, Object> profile) {
        this.profile = profile;
        return this;
    }

    public OINApplication putprofileItem(String key, Object profileItem) {
        if (this.profile == null) {
            this.profile = new HashMap<String, Object>();
        }
        this.profile.put(key, profileItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains any valid JSON schema for specifying properties that can be referenced from a request (only available to OAuth 2.0 client apps)")
    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(Map<String, Object> profile) {
        this.profile = profile;
    }

    public OINApplication signOnMode(String signOnMode) {
        this.signOnMode = signOnMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Authentication mode for the app")
    @JsonProperty(value="signOnMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSignOnMode() {
        return this.signOnMode;
    }

    @JsonProperty(value="signOnMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSignOnMode(String signOnMode) {
        this.signOnMode = signOnMode;
    }

    public OINApplication status(ApplicationLifecycleStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationLifecycleStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(ApplicationLifecycleStatus status) {
        this.status = status;
    }

    public OINApplication visibility(ApplicationVisibility visibility) {
        this.visibility = visibility;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="visibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationVisibility getVisibility() {
        return this.visibility;
    }

    @JsonProperty(value="visibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVisibility(ApplicationVisibility visibility) {
        this.visibility = visibility;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OINApplication oiNApplication = (OINApplication)o;
        return Objects.equals(this.accessibility, oiNApplication.accessibility) && Objects.equals(this.credentials, oiNApplication.credentials) && Objects.equals(this.label, oiNApplication.label) && Objects.equals(this.licensing, oiNApplication.licensing) && Objects.equals(this.name, oiNApplication.name) && Objects.equals(this.profile, oiNApplication.profile) && Objects.equals(this.signOnMode, oiNApplication.signOnMode) && Objects.equals((Object)this.status, (Object)oiNApplication.status) && Objects.equals(this.visibility, oiNApplication.visibility);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessibility, this.credentials, this.label, this.licensing, this.name, this.profile, this.signOnMode, this.status, this.visibility});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OINApplication {\n");
        sb.append("    accessibility: ").append(this.toIndentedString(this.accessibility)).append("\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    licensing: ").append(this.toIndentedString(this.licensing)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    signOnMode: ").append(this.toIndentedString(this.signOnMode)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    visibility: ").append(this.toIndentedString(this.visibility)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

