/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="The type of IdP-initiated sign-in flow that the client supports")
@JsonPropertyOrder(value={"default_scope", "mode"})
public class OpenIdConnectApplicationIdpInitiatedLogin
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DEFAULT_SCOPE = "default_scope";
    private List<String> defaultScope = null;
    public static final String JSON_PROPERTY_MODE = "mode";
    private ModeEnum mode;

    public OpenIdConnectApplicationIdpInitiatedLogin defaultScope(List<String> defaultScope) {
        this.defaultScope = defaultScope;
        return this;
    }

    public OpenIdConnectApplicationIdpInitiatedLogin adddefaultScopeItem(String defaultScopeItem) {
        if (this.defaultScope == null) {
            this.defaultScope = new ArrayList<String>();
        }
        this.defaultScope.add(defaultScopeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The scopes to use for the request when `mode` is `OKTA`")
    @JsonProperty(value="default_scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDefaultScope() {
        return this.defaultScope;
    }

    @JsonProperty(value="default_scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultScope(List<String> defaultScope) {
        this.defaultScope = defaultScope;
    }

    public OpenIdConnectApplicationIdpInitiatedLogin mode(ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The mode to use for the IdP-initiated sign-in flow. For `OKTA` or `SPEC` modes, the client must have an `initiate_login_uri` registered. > **Note:** For web and SPA apps, if the mode is `SPEC` or `OKTA`, you must set `grant_types` to `authorization_code`, `implicit`, or `interaction_code`. ")
    @JsonProperty(value="mode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ModeEnum getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenIdConnectApplicationIdpInitiatedLogin openIdConnectApplicationIdpInitiatedLogin = (OpenIdConnectApplicationIdpInitiatedLogin)o;
        return Objects.equals(this.defaultScope, openIdConnectApplicationIdpInitiatedLogin.defaultScope) && Objects.equals((Object)this.mode, (Object)openIdConnectApplicationIdpInitiatedLogin.mode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.defaultScope, this.mode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenIdConnectApplicationIdpInitiatedLogin {\n");
        sb.append("    defaultScope: ").append(this.toIndentedString(this.defaultScope)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ModeEnum {
        DISABLED("DISABLED"),
        SPEC("SPEC"),
        OKTA("OKTA"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ModeEnum fromValue(String value) {
            for (ModeEnum b : ModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

