/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.PrivilegedAccountCredentials;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Details for managing an Okta Universal Directory Account as a Privileged Account")
@JsonPropertyOrder(value={"credentials", "email", "oktaUserId"})
public class PrivilegedAccountDetailsOktaUserAccountSub
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private PrivilegedAccountCredentials credentials;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_OKTA_USER_ID = "oktaUserId";
    private String oktaUserId;

    public PrivilegedAccountDetailsOktaUserAccountSub credentials(PrivilegedAccountCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PrivilegedAccountCredentials getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCredentials(PrivilegedAccountCredentials credentials) {
        this.credentials = credentials;
    }

    public PrivilegedAccountDetailsOktaUserAccountSub email(String email) {
        this.email = email;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="foo@bar.com", required=true, value="The email address for the Okta Universal Directory Account")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmail(String email) {
        this.email = email;
    }

    public PrivilegedAccountDetailsOktaUserAccountSub oktaUserId(String oktaUserId) {
        this.oktaUserId = oktaUserId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00u11s48P9zGW8yqm0g5", value="An optional Okta user ID. If supplied, converts the matching Okta Universal Directory Account to a Privileged Account and updates the account with the provided details.")
    @JsonProperty(value="oktaUserId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOktaUserId() {
        return this.oktaUserId;
    }

    @JsonProperty(value="oktaUserId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOktaUserId(String oktaUserId) {
        this.oktaUserId = oktaUserId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivilegedAccountDetailsOktaUserAccountSub privilegedAccountDetailsOktaUserAccountSub = (PrivilegedAccountDetailsOktaUserAccountSub)o;
        return Objects.equals(this.credentials, privilegedAccountDetailsOktaUserAccountSub.credentials) && Objects.equals(this.email, privilegedAccountDetailsOktaUserAccountSub.email) && Objects.equals(this.oktaUserId, privilegedAccountDetailsOktaUserAccountSub.oktaUserId);
    }

    public int hashCode() {
        return Objects.hash(this.credentials, this.email, this.oktaUserId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrivilegedAccountDetailsOktaUserAccountSub {\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    oktaUserId: ").append(this.toIndentedString(this.oktaUserId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

