/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ApplicationAccessibility;
import com.okta.sdk.resource.model.ApplicationLicensing;
import com.okta.sdk.resource.model.ApplicationLifecycleStatus;
import com.okta.sdk.resource.model.ApplicationVisibility;
import com.okta.sdk.resource.model.SchemeApplicationCredentials;
import com.okta.sdk.resource.model.TrendMicroApexOneServiceApplicationSettings;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Schema for Trend Micro Apex One as a Service app (key name: `trendmicroapexoneservice`)  To create a Trend Micro Apex One as a Service app, use the [Create an Application](/openapi/okta-management/management/tag/Application/#tag/Application/operation/createApplication) request with the following parameters in the request body. > **Note:** The Trend Micro Apex One as a Service app only supports `SAML_2_0` sign-on mode. ")
@JsonPropertyOrder(value={"accessibility", "credentials", "label", "licensing", "name", "profile", "signOnMode", "status", "visibility", "settings"})
public class TrendMicroApexOneServiceApplication
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ACCESSIBILITY = "accessibility";
    private ApplicationAccessibility accessibility;
    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private SchemeApplicationCredentials credentials;
    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;
    public static final String JSON_PROPERTY_LICENSING = "licensing";
    private ApplicationLicensing licensing;
    public static final String JSON_PROPERTY_NAME = "name";
    private NameEnum name;
    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Map<String, Object> profile = null;
    public static final String JSON_PROPERTY_SIGN_ON_MODE = "signOnMode";
    private SignOnModeEnum signOnMode;
    public static final String JSON_PROPERTY_STATUS = "status";
    private ApplicationLifecycleStatus status;
    public static final String JSON_PROPERTY_VISIBILITY = "visibility";
    private ApplicationVisibility visibility;
    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private TrendMicroApexOneServiceApplicationSettings settings;

    public TrendMicroApexOneServiceApplication accessibility(ApplicationAccessibility accessibility) {
        this.accessibility = accessibility;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="accessibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationAccessibility getAccessibility() {
        return this.accessibility;
    }

    @JsonProperty(value="accessibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccessibility(ApplicationAccessibility accessibility) {
        this.accessibility = accessibility;
    }

    public TrendMicroApexOneServiceApplication credentials(SchemeApplicationCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SchemeApplicationCredentials getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(SchemeApplicationCredentials credentials) {
        this.credentials = credentials;
    }

    public TrendMicroApexOneServiceApplication label(String label) {
        this.label = label;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="User-defined display name for app")
    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLabel(String label) {
        this.label = label;
    }

    public TrendMicroApexOneServiceApplication licensing(ApplicationLicensing licensing) {
        this.licensing = licensing;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="licensing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationLicensing getLicensing() {
        return this.licensing;
    }

    @JsonProperty(value="licensing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLicensing(ApplicationLicensing licensing) {
        this.licensing = licensing;
    }

    public TrendMicroApexOneServiceApplication name(NameEnum name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="trendmicroapexoneservice", required=true, value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public NameEnum getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(NameEnum name) {
        this.name = name;
    }

    public TrendMicroApexOneServiceApplication profile(Map<String, Object> profile) {
        this.profile = profile;
        return this;
    }

    public TrendMicroApexOneServiceApplication putprofileItem(String key, Object profileItem) {
        if (this.profile == null) {
            this.profile = new HashMap<String, Object>();
        }
        this.profile.put(key, profileItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains any valid JSON schema for specifying properties that can be referenced from a request (only available to OAuth 2.0 client apps)")
    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(Map<String, Object> profile) {
        this.profile = profile;
    }

    public TrendMicroApexOneServiceApplication signOnMode(SignOnModeEnum signOnMode) {
        this.signOnMode = signOnMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="signOnMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SignOnModeEnum getSignOnMode() {
        return this.signOnMode;
    }

    @JsonProperty(value="signOnMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSignOnMode(SignOnModeEnum signOnMode) {
        this.signOnMode = signOnMode;
    }

    public TrendMicroApexOneServiceApplication status(ApplicationLifecycleStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationLifecycleStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(ApplicationLifecycleStatus status) {
        this.status = status;
    }

    public TrendMicroApexOneServiceApplication visibility(ApplicationVisibility visibility) {
        this.visibility = visibility;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="visibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationVisibility getVisibility() {
        return this.visibility;
    }

    @JsonProperty(value="visibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVisibility(ApplicationVisibility visibility) {
        this.visibility = visibility;
    }

    public TrendMicroApexOneServiceApplication settings(TrendMicroApexOneServiceApplicationSettings settings) {
        this.settings = settings;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TrendMicroApexOneServiceApplicationSettings getSettings() {
        return this.settings;
    }

    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSettings(TrendMicroApexOneServiceApplicationSettings settings) {
        this.settings = settings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrendMicroApexOneServiceApplication trendMicroApexOneServiceApplication = (TrendMicroApexOneServiceApplication)o;
        return Objects.equals(this.accessibility, trendMicroApexOneServiceApplication.accessibility) && Objects.equals(this.credentials, trendMicroApexOneServiceApplication.credentials) && Objects.equals(this.label, trendMicroApexOneServiceApplication.label) && Objects.equals(this.licensing, trendMicroApexOneServiceApplication.licensing) && Objects.equals((Object)this.name, (Object)trendMicroApexOneServiceApplication.name) && Objects.equals(this.profile, trendMicroApexOneServiceApplication.profile) && Objects.equals((Object)this.signOnMode, (Object)trendMicroApexOneServiceApplication.signOnMode) && Objects.equals((Object)this.status, (Object)trendMicroApexOneServiceApplication.status) && Objects.equals(this.visibility, trendMicroApexOneServiceApplication.visibility) && Objects.equals(this.settings, trendMicroApexOneServiceApplication.settings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessibility, this.credentials, this.label, this.licensing, this.name, this.profile, this.signOnMode, this.status, this.visibility, this.settings});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrendMicroApexOneServiceApplication {\n");
        sb.append("    accessibility: ").append(this.toIndentedString(this.accessibility)).append("\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    licensing: ").append(this.toIndentedString(this.licensing)).append("\n");
        sb.append("    name: ").append(this.toIndentedString((Object)this.name)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    signOnMode: ").append(this.toIndentedString((Object)this.signOnMode)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    visibility: ").append(this.toIndentedString(this.visibility)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum NameEnum {
        TRENDMICROAPEXONESERVICE("trendmicroapexoneservice"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private NameEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NameEnum fromValue(String value) {
            for (NameEnum b : NameEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum SignOnModeEnum {
        SAML_2_0("SAML_2_0"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private SignOnModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SignOnModeEnum fromValue(String value) {
            for (SignOnModeEnum b : SignOnModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

