/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.ApiToken;
import com.okta.sdk.resource.model.ApiTokenUpdate;
import com.okta.sdk.resource.model.Error;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class ApiTokenApi {

    private ApiClient apiClient;

    public ApiTokenApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiTokenApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Retrieve an API Token&#39;s Metadata Retrieves the metadata for an active API token by &#x60;apiTokenId&#x60;
     *
     * @param apiTokenId
     *            id of the API Token (required)
     *
     * @return ApiToken
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ApiToken getApiToken(String apiTokenId) throws ApiException {
        return this.getApiToken(apiTokenId, Collections.emptyMap());
    }

    /**
     * Retrieve an API Token&#39;s Metadata Retrieves the metadata for an active API token by &#x60;apiTokenId&#x60;
     *
     * @param apiTokenId
     *            id of the API Token (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ApiToken
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ApiToken getApiToken(String apiTokenId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'apiTokenId' is set
        if (apiTokenId == null) {
            throw new ApiException(400, "Missing the required parameter 'apiTokenId' when calling getApiToken");
        }

        // create path and map variables
        String localVarPath = "/api/v1/api-tokens/{apiTokenId}".replaceAll("\\{" + "apiTokenId" + "\\}",
                apiClient.escapeString(apiTokenId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ApiToken> localVarReturnType = new TypeReference<ApiToken>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all API Token Metadata Lists all the metadata of the active API tokens
     *
     * @return List&lt;ApiToken&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<ApiToken> listApiTokens() throws ApiException {
        return this.listApiTokens(Collections.emptyMap());
    }

    /**
     * List all API Token Metadata Lists all the metadata of the active API tokens
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;ApiToken&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<ApiToken> listApiTokens(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/api-tokens";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<ApiToken>> localVarReturnType = new TypeReference<List<ApiToken>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Revoke an API Token Revokes an API token by &#x60;apiTokenId&#x60;
     *
     * @param apiTokenId
     *            id of the API Token (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeApiToken(String apiTokenId) throws ApiException {
        this.revokeApiToken(apiTokenId, Collections.emptyMap());
    }

    /**
     * Revoke an API Token Revokes an API token by &#x60;apiTokenId&#x60;
     *
     * @param apiTokenId
     *            id of the API Token (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeApiToken(String apiTokenId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'apiTokenId' is set
        if (apiTokenId == null) {
            throw new ApiException(400, "Missing the required parameter 'apiTokenId' when calling revokeApiToken");
        }

        // create path and map variables
        String localVarPath = "/api/v1/api-tokens/{apiTokenId}".replaceAll("\\{" + "apiTokenId" + "\\}",
                apiClient.escapeString(apiTokenId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Revoke the Current API Token Revokes the API token provided in the Authorization header
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeCurrentApiToken() throws ApiException {
        this.revokeCurrentApiToken(Collections.emptyMap());
    }

    /**
     * Revoke the Current API Token Revokes the API token provided in the Authorization header
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeCurrentApiToken(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/api-tokens/current";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Upsert an API Token Network Condition Upserts an API Token Network Condition by &#x60;apiTokenId&#x60;
     *
     * @param apiTokenId
     *            id of the API Token (required)
     * @param apiTokenUpdate
     *            (required)
     *
     * @return ApiToken
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ApiToken upsertApiToken(String apiTokenId, ApiTokenUpdate apiTokenUpdate) throws ApiException {
        return this.upsertApiToken(apiTokenId, apiTokenUpdate, Collections.emptyMap());
    }

    /**
     * Upsert an API Token Network Condition Upserts an API Token Network Condition by &#x60;apiTokenId&#x60;
     *
     * @param apiTokenId
     *            id of the API Token (required)
     * @param apiTokenUpdate
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ApiToken
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ApiToken upsertApiToken(String apiTokenId, ApiTokenUpdate apiTokenUpdate,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = apiTokenUpdate;

        // verify the required parameter 'apiTokenId' is set
        if (apiTokenId == null) {
            throw new ApiException(400, "Missing the required parameter 'apiTokenId' when calling upsertApiToken");
        }

        // verify the required parameter 'apiTokenUpdate' is set
        if (apiTokenUpdate == null) {
            throw new ApiException(400, "Missing the required parameter 'apiTokenUpdate' when calling upsertApiToken");
        }

        // create path and map variables
        String localVarPath = "/api/v1/api-tokens/{apiTokenId}".replaceAll("\\{" + "apiTokenId" + "\\}",
                apiClient.escapeString(apiTokenId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ApiToken> localVarReturnType = new TypeReference<ApiToken>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
