/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.ApplicationGroupAssignment;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.JsonPatchOperation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class ApplicationGroupsApi {

    private ApiClient apiClient;

    public ApplicationGroupsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationGroupsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Assign an Application Group Assigns a
     * [Group](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Group/) to an app, which in
     * turn assigns the app to each
     * [User](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/User/) that belongs to the
     * group. The resulting Application User
     * [scope](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/ApplicationUsers/#tag/ApplicationUsers/operation/listApplicationUsers!c&#x3D;200&amp;path&#x3D;scope&amp;t&#x3D;response)
     * is &#x60;GROUP&#x60; since the assignment was from the group membership.
     *
     * @param appId
     *            Application ID (required)
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param applicationGroupAssignment
     *            (optional)
     *
     * @return ApplicationGroupAssignment
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ApplicationGroupAssignment assignGroupToApplication(String appId, String groupId,
            ApplicationGroupAssignment applicationGroupAssignment) throws ApiException {
        return this.assignGroupToApplication(appId, groupId, applicationGroupAssignment, Collections.emptyMap());
    }

    /**
     * Assign an Application Group Assigns a
     * [Group](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Group/) to an app, which in
     * turn assigns the app to each
     * [User](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/User/) that belongs to the
     * group. The resulting Application User
     * [scope](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/ApplicationUsers/#tag/ApplicationUsers/operation/listApplicationUsers!c&#x3D;200&amp;path&#x3D;scope&amp;t&#x3D;response)
     * is &#x60;GROUP&#x60; since the assignment was from the group membership.
     *
     * @param appId
     *            Application ID (required)
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param applicationGroupAssignment
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ApplicationGroupAssignment
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ApplicationGroupAssignment assignGroupToApplication(String appId, String groupId,
            ApplicationGroupAssignment applicationGroupAssignment, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = applicationGroupAssignment;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling assignGroupToApplication");
        }

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'groupId' when calling assignGroupToApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/groups/{groupId}"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "groupId" + "\\}", apiClient.escapeString(groupId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ApplicationGroupAssignment> localVarReturnType = new TypeReference<ApplicationGroupAssignment>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve an Application Group Retrieves an app group assignment
     *
     * @param appId
     *            Application ID (required)
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param expand
     *            An optional query parameter to return the corresponding assigned
     *            [Group](/openapi/okta-management/management/tag/Group/) or the group assignment metadata details in
     *            the &#x60;_embedded&#x60; property. (optional)
     *
     * @return ApplicationGroupAssignment
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ApplicationGroupAssignment getApplicationGroupAssignment(String appId, String groupId, String expand)
            throws ApiException {
        return this.getApplicationGroupAssignment(appId, groupId, expand, Collections.emptyMap());
    }

    /**
     * Retrieve an Application Group Retrieves an app group assignment
     *
     * @param appId
     *            Application ID (required)
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param expand
     *            An optional query parameter to return the corresponding assigned
     *            [Group](/openapi/okta-management/management/tag/Group/) or the group assignment metadata details in
     *            the &#x60;_embedded&#x60; property. (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ApplicationGroupAssignment
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ApplicationGroupAssignment getApplicationGroupAssignment(String appId, String groupId, String expand,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling getApplicationGroupAssignment");
        }

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'groupId' when calling getApplicationGroupAssignment");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/groups/{groupId}"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "groupId" + "\\}", apiClient.escapeString(groupId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ApplicationGroupAssignment> localVarReturnType = new TypeReference<ApplicationGroupAssignment>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Application Groups Lists all app group assignments
     *
     * @param appId
     *            Application ID (required)
     * @param q
     *            Specifies a filter for a list of assigned groups returned based on their names. The value of
     *            &#x60;q&#x60; is matched against the group &#x60;name&#x60;. This filter only supports the
     *            &#x60;startsWith&#x60; operation that matches the &#x60;q&#x60; string against the beginning of the
     *            [Group
     *            name](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Group/#tag/Group/operation/listGroups!c&#x3D;200&amp;path&#x3D;profile/name&amp;t&#x3D;response).
     *            (optional)
     * @param after
     *            Specifies the pagination cursor for the &#x60;next&#x60; page of results. Treat this as an opaque
     *            value obtained through the next link relationship. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            Specifies the number of objects to return per page. If there are multiple pages of results, the Link
     *            header contains a &#x60;next&#x60; link that you need to use as an opaque value (follow it, don&#39;t
     *            parse it). See [Pagination](/#pagination). (optional, default to 20)
     * @param expand
     *            An optional query parameter to return the corresponding assigned
     *            [Group](/openapi/okta-management/management/tag/Group/) or the group assignment metadata details in
     *            the &#x60;_embedded&#x60; property. (optional)
     *
     * @return List&lt;ApplicationGroupAssignment&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<ApplicationGroupAssignment> listApplicationGroupAssignments(String appId, String q, String after,
            Integer limit, String expand) throws ApiException {
        return this.listApplicationGroupAssignments(appId, q, after, limit, expand, Collections.emptyMap());
    }

    /**
     * List all Application Groups Lists all app group assignments
     *
     * @param appId
     *            Application ID (required)
     * @param q
     *            Specifies a filter for a list of assigned groups returned based on their names. The value of
     *            &#x60;q&#x60; is matched against the group &#x60;name&#x60;. This filter only supports the
     *            &#x60;startsWith&#x60; operation that matches the &#x60;q&#x60; string against the beginning of the
     *            [Group
     *            name](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Group/#tag/Group/operation/listGroups!c&#x3D;200&amp;path&#x3D;profile/name&amp;t&#x3D;response).
     *            (optional)
     * @param after
     *            Specifies the pagination cursor for the &#x60;next&#x60; page of results. Treat this as an opaque
     *            value obtained through the next link relationship. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            Specifies the number of objects to return per page. If there are multiple pages of results, the Link
     *            header contains a &#x60;next&#x60; link that you need to use as an opaque value (follow it, don&#39;t
     *            parse it). See [Pagination](/#pagination). (optional, default to 20)
     * @param expand
     *            An optional query parameter to return the corresponding assigned
     *            [Group](/openapi/okta-management/management/tag/Group/) or the group assignment metadata details in
     *            the &#x60;_embedded&#x60; property. (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;ApplicationGroupAssignment&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<ApplicationGroupAssignment> listApplicationGroupAssignments(String appId, String q, String after,
            Integer limit, String expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling listApplicationGroupAssignments");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/groups".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<ApplicationGroupAssignment>> localVarReturnType = new TypeReference<List<ApplicationGroupAssignment>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Unassign an Application Group Unassigns a Group from an app
     *
     * @param appId
     *            Application ID (required)
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unassignApplicationFromGroup(String appId, String groupId) throws ApiException {
        this.unassignApplicationFromGroup(appId, groupId, Collections.emptyMap());
    }

    /**
     * Unassign an Application Group Unassigns a Group from an app
     *
     * @param appId
     *            Application ID (required)
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unassignApplicationFromGroup(String appId, String groupId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling unassignApplicationFromGroup");
        }

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'groupId' when calling unassignApplicationFromGroup");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/groups/{groupId}"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "groupId" + "\\}", apiClient.escapeString(groupId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Update an Application Group Updates a group assignment to an app
     *
     * @param appId
     *            Application ID (required)
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param jsonPatchOperation
     *            (optional
     *
     * @return ApplicationGroupAssignment
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ApplicationGroupAssignment updateGroupAssignmentToApplication(String appId, String groupId,
            List<JsonPatchOperation> jsonPatchOperation) throws ApiException {
        return this.updateGroupAssignmentToApplication(appId, groupId, jsonPatchOperation, Collections.emptyMap());
    }

    /**
     * Update an Application Group Updates a group assignment to an app
     *
     * @param appId
     *            Application ID (required)
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param jsonPatchOperation
     *            (optional
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ApplicationGroupAssignment
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ApplicationGroupAssignment updateGroupAssignmentToApplication(String appId, String groupId,
            List<JsonPatchOperation> jsonPatchOperation, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = jsonPatchOperation;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling updateGroupAssignmentToApplication");
        }

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'groupId' when calling updateGroupAssignmentToApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/groups/{groupId}"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "groupId" + "\\}", apiClient.escapeString(groupId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ApplicationGroupAssignment> localVarReturnType = new TypeReference<ApplicationGroupAssignment>() {
        };
        return apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
