/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.AuthorizationServerJsonWebKey;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.JwkUse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class AuthorizationServerKeysApi {

    private ApiClient apiClient;

    public AuthorizationServerKeysApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthorizationServerKeysApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Retrieve an Authorization Server Key Retrieves an Authorization Server Key specified by the &#x60;keyId&#x60;
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param keyId
     *            &#x60;id&#x60; of the certificate key (required)
     *
     * @return AuthorizationServerJsonWebKey
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthorizationServerJsonWebKey getAuthorizationServerKey(String authServerId, String keyId)
            throws ApiException {
        return this.getAuthorizationServerKey(authServerId, keyId, Collections.emptyMap());
    }

    /**
     * Retrieve an Authorization Server Key Retrieves an Authorization Server Key specified by the &#x60;keyId&#x60;
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param keyId
     *            &#x60;id&#x60; of the certificate key (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AuthorizationServerJsonWebKey
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthorizationServerJsonWebKey getAuthorizationServerKey(String authServerId, String keyId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling getAuthorizationServerKey");
        }

        // verify the required parameter 'keyId' is set
        if (keyId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'keyId' when calling getAuthorizationServerKey");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/credentials/keys/{keyId}"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()))
                .replaceAll("\\{" + "keyId" + "\\}", apiClient.escapeString(keyId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AuthorizationServerJsonWebKey> localVarReturnType = new TypeReference<AuthorizationServerJsonWebKey>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Credential Keys Lists all of the current, future, and expired Keys used by the Custom Authorization
     * Server
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     *
     * @return List&lt;AuthorizationServerJsonWebKey&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<AuthorizationServerJsonWebKey> listAuthorizationServerKeys(String authServerId) throws ApiException {
        return this.listAuthorizationServerKeys(authServerId, Collections.emptyMap());
    }

    /**
     * List all Credential Keys Lists all of the current, future, and expired Keys used by the Custom Authorization
     * Server
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;AuthorizationServerJsonWebKey&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<AuthorizationServerJsonWebKey> listAuthorizationServerKeys(String authServerId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling listAuthorizationServerKeys");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/credentials/keys"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<AuthorizationServerJsonWebKey>> localVarReturnType = new TypeReference<List<AuthorizationServerJsonWebKey>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Rotate all Credential Keys Rotates the current Keys for a Custom Authorization Server. If you rotate Keys, the
     * &#x60;ACTIVE&#x60; Key becomes the &#x60;EXPIRED&#x60; Key, the &#x60;NEXT&#x60; Key becomes the
     * &#x60;ACTIVE&#x60; Key, and the Custom Authorization Server immediately begins using the new active Key to sign
     * tokens. &gt; **Note:** Okta rotates your Keys automatically in &#x60;AUTO&#x60; mode. You can rotate Keys
     * yourself in either mode. If Keys are rotated manually, you should invalidate any intermediate cache and fetch the
     * Keys again using the Keys endpoint.
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param use
     *            (required)
     *
     * @return List&lt;AuthorizationServerJsonWebKey&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<AuthorizationServerJsonWebKey> rotateAuthorizationServerKeys(String authServerId, JwkUse use)
            throws ApiException {
        return this.rotateAuthorizationServerKeys(authServerId, use, Collections.emptyMap());
    }

    /**
     * Rotate all Credential Keys Rotates the current Keys for a Custom Authorization Server. If you rotate Keys, the
     * &#x60;ACTIVE&#x60; Key becomes the &#x60;EXPIRED&#x60; Key, the &#x60;NEXT&#x60; Key becomes the
     * &#x60;ACTIVE&#x60; Key, and the Custom Authorization Server immediately begins using the new active Key to sign
     * tokens. &gt; **Note:** Okta rotates your Keys automatically in &#x60;AUTO&#x60; mode. You can rotate Keys
     * yourself in either mode. If Keys are rotated manually, you should invalidate any intermediate cache and fetch the
     * Keys again using the Keys endpoint.
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param use
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;AuthorizationServerJsonWebKey&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<AuthorizationServerJsonWebKey> rotateAuthorizationServerKeys(String authServerId, JwkUse use,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = use;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling rotateAuthorizationServerKeys");
        }

        // verify the required parameter 'use' is set
        if (use == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'use' when calling rotateAuthorizationServerKeys");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/credentials/lifecycle/keyRotate"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<AuthorizationServerJsonWebKey>> localVarReturnType = new TypeReference<List<AuthorizationServerJsonWebKey>>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
