/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.DomainCertificate;
import com.okta.sdk.resource.model.DomainListResponse;
import com.okta.sdk.resource.model.DomainRequest;
import com.okta.sdk.resource.model.DomainResponse;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.UpdateDomain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class CustomDomainApi {

    private ApiClient apiClient;

    public CustomDomainApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomDomainApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create a Custom Domain Creates your custom domain
     *
     * @param domain
     *            (required)
     *
     * @return DomainResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DomainResponse createCustomDomain(DomainRequest domain) throws ApiException {
        return this.createCustomDomain(domain, Collections.emptyMap());
    }

    /**
     * Create a Custom Domain Creates your custom domain
     *
     * @param domain
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return DomainResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DomainResponse createCustomDomain(DomainRequest domain, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = domain;

        // verify the required parameter 'domain' is set
        if (domain == null) {
            throw new ApiException(400, "Missing the required parameter 'domain' when calling createCustomDomain");
        }

        // create path and map variables
        String localVarPath = "/api/v1/domains";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<DomainResponse> localVarReturnType = new TypeReference<DomainResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a Custom Domain Deletes a custom domain by &#x60;domainId&#x60;
     *
     * @param domainId
     *            &#x60;id&#x60; of the Domain (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteCustomDomain(String domainId) throws ApiException {
        this.deleteCustomDomain(domainId, Collections.emptyMap());
    }

    /**
     * Delete a Custom Domain Deletes a custom domain by &#x60;domainId&#x60;
     *
     * @param domainId
     *            &#x60;id&#x60; of the Domain (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteCustomDomain(String domainId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'domainId' is set
        if (domainId == null) {
            throw new ApiException(400, "Missing the required parameter 'domainId' when calling deleteCustomDomain");
        }

        // create path and map variables
        String localVarPath = "/api/v1/domains/{domainId}".replaceAll("\\{" + "domainId" + "\\}",
                apiClient.escapeString(domainId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a Custom Domain Retrieves a custom domain by &#x60;domainId&#x60;
     *
     * @param domainId
     *            &#x60;id&#x60; of the Domain (required)
     *
     * @return DomainResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DomainResponse getCustomDomain(String domainId) throws ApiException {
        return this.getCustomDomain(domainId, Collections.emptyMap());
    }

    /**
     * Retrieve a Custom Domain Retrieves a custom domain by &#x60;domainId&#x60;
     *
     * @param domainId
     *            &#x60;id&#x60; of the Domain (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return DomainResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DomainResponse getCustomDomain(String domainId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'domainId' is set
        if (domainId == null) {
            throw new ApiException(400, "Missing the required parameter 'domainId' when calling getCustomDomain");
        }

        // create path and map variables
        String localVarPath = "/api/v1/domains/{domainId}".replaceAll("\\{" + "domainId" + "\\}",
                apiClient.escapeString(domainId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<DomainResponse> localVarReturnType = new TypeReference<DomainResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Custom Domains Lists all verified custom domains for the org
     *
     * @return DomainListResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DomainListResponse listCustomDomains() throws ApiException {
        return this.listCustomDomains(Collections.emptyMap());
    }

    /**
     * List all Custom Domains Lists all verified custom domains for the org
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return DomainListResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DomainListResponse listCustomDomains(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/domains";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<DomainListResponse> localVarReturnType = new TypeReference<DomainListResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a Custom Domain&#39;s Brand Replaces a custom domain&#39;s brand
     *
     * @param domainId
     *            &#x60;id&#x60; of the Domain (required)
     * @param updateDomain
     *            (required)
     *
     * @return DomainResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DomainResponse replaceCustomDomain(String domainId, UpdateDomain updateDomain) throws ApiException {
        return this.replaceCustomDomain(domainId, updateDomain, Collections.emptyMap());
    }

    /**
     * Replace a Custom Domain&#39;s Brand Replaces a custom domain&#39;s brand
     *
     * @param domainId
     *            &#x60;id&#x60; of the Domain (required)
     * @param updateDomain
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return DomainResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DomainResponse replaceCustomDomain(String domainId, UpdateDomain updateDomain,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = updateDomain;

        // verify the required parameter 'domainId' is set
        if (domainId == null) {
            throw new ApiException(400, "Missing the required parameter 'domainId' when calling replaceCustomDomain");
        }

        // verify the required parameter 'updateDomain' is set
        if (updateDomain == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'updateDomain' when calling replaceCustomDomain");
        }

        // create path and map variables
        String localVarPath = "/api/v1/domains/{domainId}".replaceAll("\\{" + "domainId" + "\\}",
                apiClient.escapeString(domainId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<DomainResponse> localVarReturnType = new TypeReference<DomainResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Upsert the Custom Domain&#39;s Certificate Upserts (creates or renews) the &#x60;MANUAL&#x60; certificate for the
     * custom domain &gt; **Notes:** &gt; * If the existing &#x60;certificateSourceType&#x60; is
     * &#x60;OKTA_MANAGED&#x60;, this operation changes the source type to &#x60;MANUAL&#x60;. Okta no longer manages
     * and renews certificates for this domain after you provide a user-managed certificate. &gt; * Okta supports TLS
     * certificates and private keys that are PEM-encoded and 2048, 3072, or 4096 bits. See the [Custom domain
     * guide](https://developer.okta.com/docs/guides/custom-url-domain/main/) for more details.
     *
     * @param domainId
     *            &#x60;id&#x60; of the Domain (required)
     * @param certificate
     *            (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void upsertCertificate(String domainId, DomainCertificate certificate) throws ApiException {
        this.upsertCertificate(domainId, certificate, Collections.emptyMap());
    }

    /**
     * Upsert the Custom Domain&#39;s Certificate Upserts (creates or renews) the &#x60;MANUAL&#x60; certificate for the
     * custom domain &gt; **Notes:** &gt; * If the existing &#x60;certificateSourceType&#x60; is
     * &#x60;OKTA_MANAGED&#x60;, this operation changes the source type to &#x60;MANUAL&#x60;. Okta no longer manages
     * and renews certificates for this domain after you provide a user-managed certificate. &gt; * Okta supports TLS
     * certificates and private keys that are PEM-encoded and 2048, 3072, or 4096 bits. See the [Custom domain
     * guide](https://developer.okta.com/docs/guides/custom-url-domain/main/) for more details.
     *
     * @param domainId
     *            &#x60;id&#x60; of the Domain (required)
     * @param certificate
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void upsertCertificate(String domainId, DomainCertificate certificate, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = certificate;

        // verify the required parameter 'domainId' is set
        if (domainId == null) {
            throw new ApiException(400, "Missing the required parameter 'domainId' when calling upsertCertificate");
        }

        // verify the required parameter 'certificate' is set
        if (certificate == null) {
            throw new ApiException(400, "Missing the required parameter 'certificate' when calling upsertCertificate");
        }

        // create path and map variables
        String localVarPath = "/api/v1/domains/{domainId}/certificate".replaceAll("\\{" + "domainId" + "\\}",
                apiClient.escapeString(domainId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Verify a Custom Domain Verifies the custom domain and validity of DNS records by &#x60;domainId&#x60;.
     * Furthermore, if the &#x60;certificateSourceType&#x60; in the domain is &#x60;OKTA_MANAGED&#x60;, then an attempt
     * is made to obtain and install a certificate. After a certificate is obtained and installed by Okta, Okta manages
     * the certificate including certificate renewal.
     *
     * @param domainId
     *            &#x60;id&#x60; of the Domain (required)
     *
     * @return DomainResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DomainResponse verifyDomain(String domainId) throws ApiException {
        return this.verifyDomain(domainId, Collections.emptyMap());
    }

    /**
     * Verify a Custom Domain Verifies the custom domain and validity of DNS records by &#x60;domainId&#x60;.
     * Furthermore, if the &#x60;certificateSourceType&#x60; in the domain is &#x60;OKTA_MANAGED&#x60;, then an attempt
     * is made to obtain and install a certificate. After a certificate is obtained and installed by Okta, Okta manages
     * the certificate including certificate renewal.
     *
     * @param domainId
     *            &#x60;id&#x60; of the Domain (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return DomainResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DomainResponse verifyDomain(String domainId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'domainId' is set
        if (domainId == null) {
            throw new ApiException(400, "Missing the required parameter 'domainId' when calling verifyDomain");
        }

        // create path and map variables
        String localVarPath = "/api/v1/domains/{domainId}/verify".replaceAll("\\{" + "domainId" + "\\}",
                apiClient.escapeString(domainId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<DomainResponse> localVarReturnType = new TypeReference<DomainResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
