/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.AssignGroupOwnerRequestBody;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.GroupOwner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class GroupOwnerApi {

    private ApiClient apiClient;

    public GroupOwnerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GroupOwnerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Assign a Group Owner Assigns a group owner
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param assignGroupOwnerRequestBody
     *            (required)
     *
     * @return GroupOwner
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public GroupOwner assignGroupOwner(String groupId, AssignGroupOwnerRequestBody assignGroupOwnerRequestBody)
            throws ApiException {
        return this.assignGroupOwner(groupId, assignGroupOwnerRequestBody, Collections.emptyMap());
    }

    /**
     * Assign a Group Owner Assigns a group owner
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param assignGroupOwnerRequestBody
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return GroupOwner
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public GroupOwner assignGroupOwner(String groupId, AssignGroupOwnerRequestBody assignGroupOwnerRequestBody,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = assignGroupOwnerRequestBody;

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling assignGroupOwner");
        }

        // verify the required parameter 'assignGroupOwnerRequestBody' is set
        if (assignGroupOwnerRequestBody == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'assignGroupOwnerRequestBody' when calling assignGroupOwner");
        }

        // create path and map variables
        String localVarPath = "/api/v1/groups/{groupId}/owners".replaceAll("\\{" + "groupId" + "\\}",
                apiClient.escapeString(groupId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<GroupOwner> localVarReturnType = new TypeReference<GroupOwner>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a Group Owner Deletes a group owner from a specific group
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param ownerId
     *            The &#x60;id&#x60; of the group owner (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteGroupOwner(String groupId, String ownerId) throws ApiException {
        this.deleteGroupOwner(groupId, ownerId, Collections.emptyMap());
    }

    /**
     * Delete a Group Owner Deletes a group owner from a specific group
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param ownerId
     *            The &#x60;id&#x60; of the group owner (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteGroupOwner(String groupId, String ownerId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling deleteGroupOwner");
        }

        // verify the required parameter 'ownerId' is set
        if (ownerId == null) {
            throw new ApiException(400, "Missing the required parameter 'ownerId' when calling deleteGroupOwner");
        }

        // create path and map variables
        String localVarPath = "/api/v1/groups/{groupId}/owners/{ownerId}"
                .replaceAll("\\{" + "groupId" + "\\}", apiClient.escapeString(groupId.toString()))
                .replaceAll("\\{" + "ownerId" + "\\}", apiClient.escapeString(ownerId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * List all Group Owners Lists all owners for a specific group
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param search
     *            SCIM Filter expression for group owners. Allows to filter owners by type. (optional)
     * @param after
     *            Specifies the pagination cursor for the next page of owners (optional)
     * @param limit
     *            Specifies the number of owner results in a page (optional, default to 1000)
     *
     * @return List&lt;GroupOwner&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<GroupOwner> listGroupOwners(String groupId, String search, String after, Integer limit)
            throws ApiException {
        return this.listGroupOwners(groupId, search, after, limit, Collections.emptyMap());
    }

    /**
     * List all Group Owners Lists all owners for a specific group
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param search
     *            SCIM Filter expression for group owners. Allows to filter owners by type. (optional)
     * @param after
     *            Specifies the pagination cursor for the next page of owners (optional)
     * @param limit
     *            Specifies the number of owner results in a page (optional, default to 1000)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;GroupOwner&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<GroupOwner> listGroupOwners(String groupId, String search, String after, Integer limit,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling listGroupOwners");
        }

        // create path and map variables
        String localVarPath = "/api/v1/groups/{groupId}/owners".replaceAll("\\{" + "groupId" + "\\}",
                apiClient.escapeString(groupId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("search", search));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<GroupOwner>> localVarReturnType = new TypeReference<List<GroupOwner>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
