/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.IdPCertificateCredential;
import com.okta.sdk.resource.model.IdPKeyCredential;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class IdentityProviderKeysApi {

    private ApiClient apiClient;

    public IdentityProviderKeysApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IdentityProviderKeysApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create an IdP Key Credential Creates a new X.509 certificate credential in the IdP key store &gt; **Note:**
     * RSA-based certificates are supported for all IdP types. Okta currently supports EC-based certificates only for
     * the &#x60;X509&#x60; IdP type. For EC-based certificates we support only P-256, P-384, and P-521 curves.
     *
     * @param jsonWebKey
     *            (required)
     *
     * @return IdPKeyCredential
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdPKeyCredential createIdentityProviderKey(IdPCertificateCredential jsonWebKey) throws ApiException {
        return this.createIdentityProviderKey(jsonWebKey, Collections.emptyMap());
    }

    /**
     * Create an IdP Key Credential Creates a new X.509 certificate credential in the IdP key store &gt; **Note:**
     * RSA-based certificates are supported for all IdP types. Okta currently supports EC-based certificates only for
     * the &#x60;X509&#x60; IdP type. For EC-based certificates we support only P-256, P-384, and P-521 curves.
     *
     * @param jsonWebKey
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return IdPKeyCredential
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdPKeyCredential createIdentityProviderKey(IdPCertificateCredential jsonWebKey,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = jsonWebKey;

        // verify the required parameter 'jsonWebKey' is set
        if (jsonWebKey == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'jsonWebKey' when calling createIdentityProviderKey");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps/credentials/keys";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<IdPKeyCredential> localVarReturnType = new TypeReference<IdPKeyCredential>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete an IdP Key Credential Deletes a specific IdP Key Credential by &#x60;kid&#x60; if it isn&#39;t currently
     * being used by an active or inactive IdP
     *
     * @param kid
     *            Unique &#x60;id&#x60; of the IdP Key Credential (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteIdentityProviderKey(String kid) throws ApiException {
        this.deleteIdentityProviderKey(kid, Collections.emptyMap());
    }

    /**
     * Delete an IdP Key Credential Deletes a specific IdP Key Credential by &#x60;kid&#x60; if it isn&#39;t currently
     * being used by an active or inactive IdP
     *
     * @param kid
     *            Unique &#x60;id&#x60; of the IdP Key Credential (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteIdentityProviderKey(String kid, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'kid' is set
        if (kid == null) {
            throw new ApiException(400, "Missing the required parameter 'kid' when calling deleteIdentityProviderKey");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps/credentials/keys/{kid}".replaceAll("\\{" + "kid" + "\\}",
                apiClient.escapeString(kid.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve an IdP Key Credential Retrieves a specific IdP Key Credential by &#x60;kid&#x60;
     *
     * @param kid
     *            Unique &#x60;id&#x60; of the IdP Key Credential (required)
     *
     * @return IdPKeyCredential
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdPKeyCredential getIdentityProviderKey(String kid) throws ApiException {
        return this.getIdentityProviderKey(kid, Collections.emptyMap());
    }

    /**
     * Retrieve an IdP Key Credential Retrieves a specific IdP Key Credential by &#x60;kid&#x60;
     *
     * @param kid
     *            Unique &#x60;id&#x60; of the IdP Key Credential (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return IdPKeyCredential
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdPKeyCredential getIdentityProviderKey(String kid, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'kid' is set
        if (kid == null) {
            throw new ApiException(400, "Missing the required parameter 'kid' when calling getIdentityProviderKey");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps/credentials/keys/{kid}".replaceAll("\\{" + "kid" + "\\}",
                apiClient.escapeString(kid.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<IdPKeyCredential> localVarReturnType = new TypeReference<IdPKeyCredential>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all IdP Key Credentials Lists all IdP Key Credentials
     *
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            A limit on the number of objects to return (optional, default to 20)
     *
     * @return List&lt;IdPKeyCredential&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<IdPKeyCredential> listIdentityProviderKeys(String after, Integer limit) throws ApiException {
        return this.listIdentityProviderKeys(after, limit, Collections.emptyMap());
    }

    /**
     * List all IdP Key Credentials Lists all IdP Key Credentials
     *
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            A limit on the number of objects to return (optional, default to 20)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;IdPKeyCredential&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<IdPKeyCredential> listIdentityProviderKeys(String after, Integer limit,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/idps/credentials/keys";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<IdPKeyCredential>> localVarReturnType = new TypeReference<List<IdPKeyCredential>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace an IdP Key Credential Replaces an IdP Key Credential by &#x60;kid&#x60;
     *
     * @param kid
     *            Unique &#x60;id&#x60; of the IdP Key Credential (required)
     * @param idPKeyCredential
     *            Updated IdP Key Credential (required)
     *
     * @return IdPKeyCredential
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdPKeyCredential replaceIdentityProviderKey(String kid, IdPKeyCredential idPKeyCredential)
            throws ApiException {
        return this.replaceIdentityProviderKey(kid, idPKeyCredential, Collections.emptyMap());
    }

    /**
     * Replace an IdP Key Credential Replaces an IdP Key Credential by &#x60;kid&#x60;
     *
     * @param kid
     *            Unique &#x60;id&#x60; of the IdP Key Credential (required)
     * @param idPKeyCredential
     *            Updated IdP Key Credential (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return IdPKeyCredential
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdPKeyCredential replaceIdentityProviderKey(String kid, IdPKeyCredential idPKeyCredential,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = idPKeyCredential;

        // verify the required parameter 'kid' is set
        if (kid == null) {
            throw new ApiException(400, "Missing the required parameter 'kid' when calling replaceIdentityProviderKey");
        }

        // verify the required parameter 'idPKeyCredential' is set
        if (idPKeyCredential == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'idPKeyCredential' when calling replaceIdentityProviderKey");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps/credentials/keys/{kid}".replaceAll("\\{" + "kid" + "\\}",
                apiClient.escapeString(kid.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<IdPKeyCredential> localVarReturnType = new TypeReference<IdPKeyCredential>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
