/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.OrgAerialConsent;
import com.okta.sdk.resource.model.OrgAerialConsentDetails;
import com.okta.sdk.resource.model.OrgAerialConsentRevoked;
import com.okta.sdk.resource.model.OrgOktaSupportSettingsObj;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OrgSettingSupportApi {

    private ApiClient apiClient;

    public OrgSettingSupportApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OrgSettingSupportApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Extend Okta Support Access Extends the length of time that Okta Support can access your org by 24 hours. This
     * means that 24 hours are added to the remaining access time.
     *
     * @return OrgOktaSupportSettingsObj
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgOktaSupportSettingsObj extendOktaSupport() throws ApiException {
        return this.extendOktaSupport(Collections.emptyMap());
    }

    /**
     * Extend Okta Support Access Extends the length of time that Okta Support can access your org by 24 hours. This
     * means that 24 hours are added to the remaining access time.
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OrgOktaSupportSettingsObj
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgOktaSupportSettingsObj extendOktaSupport(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/org/privacy/oktaSupport/extend";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OrgOktaSupportSettingsObj> localVarReturnType = new TypeReference<OrgOktaSupportSettingsObj>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve Okta Aerial consent for your Org Retrieves the Okta Aerial consent grant details for your Org. Returns a
     * 404 Not Found error if no consent has been granted.
     *
     * @return OrgAerialConsentDetails
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgAerialConsentDetails getAerialConsent() throws ApiException {
        return this.getAerialConsent(Collections.emptyMap());
    }

    /**
     * Retrieve Okta Aerial consent for your Org Retrieves the Okta Aerial consent grant details for your Org. Returns a
     * 404 Not Found error if no consent has been granted.
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OrgAerialConsentDetails
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgAerialConsentDetails getAerialConsent(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/org/privacy/aerial";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OrgAerialConsentDetails> localVarReturnType = new TypeReference<OrgAerialConsentDetails>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve the Okta Support Settings Retrieves Okta Support Settings for your org
     *
     * @return OrgOktaSupportSettingsObj
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgOktaSupportSettingsObj getOrgOktaSupportSettings() throws ApiException {
        return this.getOrgOktaSupportSettings(Collections.emptyMap());
    }

    /**
     * Retrieve the Okta Support Settings Retrieves Okta Support Settings for your org
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OrgOktaSupportSettingsObj
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgOktaSupportSettingsObj getOrgOktaSupportSettings(Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/org/privacy/oktaSupport";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OrgOktaSupportSettingsObj> localVarReturnType = new TypeReference<OrgOktaSupportSettingsObj>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Grant Okta Aerial access to your Org Grants an Okta Aerial account access to your Org. If the org is a child org,
     * consent is taken from the parent org. Grant calls directly to the child are not allowed.
     *
     * @param orgAerialConsent
     *            (optional)
     *
     * @return OrgAerialConsentDetails
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgAerialConsentDetails grantAerialConsent(OrgAerialConsent orgAerialConsent) throws ApiException {
        return this.grantAerialConsent(orgAerialConsent, Collections.emptyMap());
    }

    /**
     * Grant Okta Aerial access to your Org Grants an Okta Aerial account access to your Org. If the org is a child org,
     * consent is taken from the parent org. Grant calls directly to the child are not allowed.
     *
     * @param orgAerialConsent
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OrgAerialConsentDetails
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgAerialConsentDetails grantAerialConsent(OrgAerialConsent orgAerialConsent,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = orgAerialConsent;

        // create path and map variables
        String localVarPath = "/api/v1/org/privacy/aerial/grant";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OrgAerialConsentDetails> localVarReturnType = new TypeReference<OrgAerialConsentDetails>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Grant Okta Support Access Grants Okta Support temporary access your org as an administrator for eight hours
     *
     * @return OrgOktaSupportSettingsObj
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgOktaSupportSettingsObj grantOktaSupport() throws ApiException {
        return this.grantOktaSupport(Collections.emptyMap());
    }

    /**
     * Grant Okta Support Access Grants Okta Support temporary access your org as an administrator for eight hours
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OrgOktaSupportSettingsObj
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgOktaSupportSettingsObj grantOktaSupport(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/org/privacy/oktaSupport/grant";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OrgOktaSupportSettingsObj> localVarReturnType = new TypeReference<OrgOktaSupportSettingsObj>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Revoke Okta Aerial access to your Org Revokes access of an Okta Aerial account to your Org. The revoke operation
     * will fail if the org has already been added to an Aerial account.
     *
     * @param orgAerialConsent
     *            (optional)
     *
     * @return OrgAerialConsentRevoked
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgAerialConsentRevoked revokeAerialConsent(OrgAerialConsent orgAerialConsent) throws ApiException {
        return this.revokeAerialConsent(orgAerialConsent, Collections.emptyMap());
    }

    /**
     * Revoke Okta Aerial access to your Org Revokes access of an Okta Aerial account to your Org. The revoke operation
     * will fail if the org has already been added to an Aerial account.
     *
     * @param orgAerialConsent
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OrgAerialConsentRevoked
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgAerialConsentRevoked revokeAerialConsent(OrgAerialConsent orgAerialConsent,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = orgAerialConsent;

        // create path and map variables
        String localVarPath = "/api/v1/org/privacy/aerial/revoke";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OrgAerialConsentRevoked> localVarReturnType = new TypeReference<OrgAerialConsentRevoked>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Revoke Okta Support Access Revokes Okta Support access to your org
     *
     * @return OrgOktaSupportSettingsObj
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgOktaSupportSettingsObj revokeOktaSupport() throws ApiException {
        return this.revokeOktaSupport(Collections.emptyMap());
    }

    /**
     * Revoke Okta Support Access Revokes Okta Support access to your org
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OrgOktaSupportSettingsObj
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgOktaSupportSettingsObj revokeOktaSupport(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/org/privacy/oktaSupport/revoke";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OrgOktaSupportSettingsObj> localVarReturnType = new TypeReference<OrgOktaSupportSettingsObj>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
