/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.PerClientRateLimitSettings;
import com.okta.sdk.resource.model.RateLimitAdminNotifications;
import com.okta.sdk.resource.model.RateLimitWarningThresholdRequest;
import com.okta.sdk.resource.model.RateLimitWarningThresholdResponse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class RateLimitSettingsApi {

    private ApiClient apiClient;

    public RateLimitSettingsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RateLimitSettingsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Retrieve the Rate Limit Admin Notification Settings Retrieves the currently configured Rate Limit Admin
     * Notification Settings
     *
     * @return RateLimitAdminNotifications
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public RateLimitAdminNotifications getRateLimitSettingsAdminNotifications() throws ApiException {
        return this.getRateLimitSettingsAdminNotifications(Collections.emptyMap());
    }

    /**
     * Retrieve the Rate Limit Admin Notification Settings Retrieves the currently configured Rate Limit Admin
     * Notification Settings
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return RateLimitAdminNotifications
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public RateLimitAdminNotifications getRateLimitSettingsAdminNotifications(Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/rate-limit-settings/admin-notifications";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<RateLimitAdminNotifications> localVarReturnType = new TypeReference<RateLimitAdminNotifications>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve the Per-Client Rate Limit Settings Retrieves the currently configured Per-Client Rate Limit Settings
     *
     * @return PerClientRateLimitSettings
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public PerClientRateLimitSettings getRateLimitSettingsPerClient() throws ApiException {
        return this.getRateLimitSettingsPerClient(Collections.emptyMap());
    }

    /**
     * Retrieve the Per-Client Rate Limit Settings Retrieves the currently configured Per-Client Rate Limit Settings
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return PerClientRateLimitSettings
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public PerClientRateLimitSettings getRateLimitSettingsPerClient(Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/rate-limit-settings/per-client";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<PerClientRateLimitSettings> localVarReturnType = new TypeReference<PerClientRateLimitSettings>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve the Rate Limit Warning Threshold Percentage Retrieves the currently configured threshold for warning
     * notifications when the API&#39;s rate limit is exceeded
     *
     * @return RateLimitWarningThresholdResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public RateLimitWarningThresholdResponse getRateLimitSettingsWarningThreshold() throws ApiException {
        return this.getRateLimitSettingsWarningThreshold(Collections.emptyMap());
    }

    /**
     * Retrieve the Rate Limit Warning Threshold Percentage Retrieves the currently configured threshold for warning
     * notifications when the API&#39;s rate limit is exceeded
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return RateLimitWarningThresholdResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public RateLimitWarningThresholdResponse getRateLimitSettingsWarningThreshold(Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/rate-limit-settings/warning-threshold";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<RateLimitWarningThresholdResponse> localVarReturnType = new TypeReference<RateLimitWarningThresholdResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace the Rate Limit Admin Notification Settings Replaces the Rate Limit Admin Notification Settings and
     * returns the configured properties
     *
     * @param rateLimitAdminNotifications
     *            (required)
     *
     * @return RateLimitAdminNotifications
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public RateLimitAdminNotifications replaceRateLimitSettingsAdminNotifications(
            RateLimitAdminNotifications rateLimitAdminNotifications) throws ApiException {
        return this.replaceRateLimitSettingsAdminNotifications(rateLimitAdminNotifications, Collections.emptyMap());
    }

    /**
     * Replace the Rate Limit Admin Notification Settings Replaces the Rate Limit Admin Notification Settings and
     * returns the configured properties
     *
     * @param rateLimitAdminNotifications
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return RateLimitAdminNotifications
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public RateLimitAdminNotifications replaceRateLimitSettingsAdminNotifications(
            RateLimitAdminNotifications rateLimitAdminNotifications, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = rateLimitAdminNotifications;

        // verify the required parameter 'rateLimitAdminNotifications' is set
        if (rateLimitAdminNotifications == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'rateLimitAdminNotifications' when calling replaceRateLimitSettingsAdminNotifications");
        }

        // create path and map variables
        String localVarPath = "/api/v1/rate-limit-settings/admin-notifications";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<RateLimitAdminNotifications> localVarReturnType = new TypeReference<RateLimitAdminNotifications>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace the Per-Client Rate Limit Settings Replaces the Per-Client Rate Limit Settings and returns the configured
     * properties
     *
     * @param perClientRateLimitSettings
     *            (required)
     *
     * @return PerClientRateLimitSettings
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public PerClientRateLimitSettings replaceRateLimitSettingsPerClient(
            PerClientRateLimitSettings perClientRateLimitSettings) throws ApiException {
        return this.replaceRateLimitSettingsPerClient(perClientRateLimitSettings, Collections.emptyMap());
    }

    /**
     * Replace the Per-Client Rate Limit Settings Replaces the Per-Client Rate Limit Settings and returns the configured
     * properties
     *
     * @param perClientRateLimitSettings
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return PerClientRateLimitSettings
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public PerClientRateLimitSettings replaceRateLimitSettingsPerClient(
            PerClientRateLimitSettings perClientRateLimitSettings, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = perClientRateLimitSettings;

        // verify the required parameter 'perClientRateLimitSettings' is set
        if (perClientRateLimitSettings == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'perClientRateLimitSettings' when calling replaceRateLimitSettingsPerClient");
        }

        // create path and map variables
        String localVarPath = "/api/v1/rate-limit-settings/per-client";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<PerClientRateLimitSettings> localVarReturnType = new TypeReference<PerClientRateLimitSettings>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace the Rate Limit Warning Threshold Percentage Replaces the Rate Limit Warning Threshold Percentage and
     * returns the configured property
     *
     * @param rateLimitWarningThreshold
     *            (optional)
     *
     * @return RateLimitWarningThresholdResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public RateLimitWarningThresholdResponse replaceRateLimitSettingsWarningThreshold(
            RateLimitWarningThresholdRequest rateLimitWarningThreshold) throws ApiException {
        return this.replaceRateLimitSettingsWarningThreshold(rateLimitWarningThreshold, Collections.emptyMap());
    }

    /**
     * Replace the Rate Limit Warning Threshold Percentage Replaces the Rate Limit Warning Threshold Percentage and
     * returns the configured property
     *
     * @param rateLimitWarningThreshold
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return RateLimitWarningThresholdResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public RateLimitWarningThresholdResponse replaceRateLimitSettingsWarningThreshold(
            RateLimitWarningThresholdRequest rateLimitWarningThreshold, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = rateLimitWarningThreshold;

        // create path and map variables
        String localVarPath = "/api/v1/rate-limit-settings/warning-threshold";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<RateLimitWarningThresholdResponse> localVarReturnType = new TypeReference<RateLimitWarningThresholdResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
