/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.AssignRoleToGroupRequest;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.ListGroupAssignedRoles200ResponseInner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class RoleAssignmentClientApi {

    private ApiClient apiClient;

    public RoleAssignmentClientApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleAssignmentClientApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Assign a Client Role Assigns a [standard role](/openapi/okta-management/guides/roles/#standard-roles) to a Client
     * Application. You can also assign a custom role to a Client Application, but the preferred method to assign a
     * custom role to a client is to create a binding between the Custom Role, the Resource Set, and the Client
     * Application. See [Create a Role Resource Set
     * Binding](/openapi/okta-management/management/tag/RoleDResourceSetBinding/#tag/RoleDResourceSetBinding/operation/createResourceSetBinding).
     * &gt; **Notes:** &gt; * The request payload is different for standard and custom role assignments. &gt; * For
     * IAM-based standard role assignments, use the request payload for standard roles. However, the response payload
     * for IAM-based role assignments is similar to the custom role&#39;s assignment response.
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param assignRoleToGroupRequest
     *            (required)
     *
     * @return ListGroupAssignedRoles200ResponseInner
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ListGroupAssignedRoles200ResponseInner assignRoleToClient(String clientId,
            AssignRoleToGroupRequest assignRoleToGroupRequest) throws ApiException {
        return this.assignRoleToClient(clientId, assignRoleToGroupRequest, Collections.emptyMap());
    }

    /**
     * Assign a Client Role Assigns a [standard role](/openapi/okta-management/guides/roles/#standard-roles) to a Client
     * Application. You can also assign a custom role to a Client Application, but the preferred method to assign a
     * custom role to a client is to create a binding between the Custom Role, the Resource Set, and the Client
     * Application. See [Create a Role Resource Set
     * Binding](/openapi/okta-management/management/tag/RoleDResourceSetBinding/#tag/RoleDResourceSetBinding/operation/createResourceSetBinding).
     * &gt; **Notes:** &gt; * The request payload is different for standard and custom role assignments. &gt; * For
     * IAM-based standard role assignments, use the request payload for standard roles. However, the response payload
     * for IAM-based role assignments is similar to the custom role&#39;s assignment response.
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param assignRoleToGroupRequest
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ListGroupAssignedRoles200ResponseInner
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ListGroupAssignedRoles200ResponseInner assignRoleToClient(String clientId,
            AssignRoleToGroupRequest assignRoleToGroupRequest, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = assignRoleToGroupRequest;

        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling assignRoleToClient");
        }

        // verify the required parameter 'assignRoleToGroupRequest' is set
        if (assignRoleToGroupRequest == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'assignRoleToGroupRequest' when calling assignRoleToClient");
        }

        // create path and map variables
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles".replaceAll("\\{" + "clientId" + "\\}",
                apiClient.escapeString(clientId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ListGroupAssignedRoles200ResponseInner> localVarReturnType = new TypeReference<ListGroupAssignedRoles200ResponseInner>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Unassign a Client Role Unassigns a Role Assignment (identified by &#x60;roleAssignmentId&#x60;) from a Client
     * Application (identified by &#x60;clientId&#x60;)
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteRoleFromClient(String clientId, String roleAssignmentId) throws ApiException {
        this.deleteRoleFromClient(clientId, roleAssignmentId, Collections.emptyMap());
    }

    /**
     * Unassign a Client Role Unassigns a Role Assignment (identified by &#x60;roleAssignmentId&#x60;) from a Client
     * Application (identified by &#x60;clientId&#x60;)
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteRoleFromClient(String clientId, String roleAssignmentId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling deleteRoleFromClient");
        }

        // verify the required parameter 'roleAssignmentId' is set
        if (roleAssignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleAssignmentId' when calling deleteRoleFromClient");
        }

        // create path and map variables
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}"
                .replaceAll("\\{" + "clientId" + "\\}", apiClient.escapeString(clientId.toString()))
                .replaceAll("\\{" + "roleAssignmentId" + "\\}", apiClient.escapeString(roleAssignmentId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * List all Client Role Assignments Lists all roles assigned to a Client Application identified by
     * &#x60;clientId&#x60;
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     *
     * @return ListGroupAssignedRoles200ResponseInner
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ListGroupAssignedRoles200ResponseInner listRolesForClient(String clientId) throws ApiException {
        return this.listRolesForClient(clientId, Collections.emptyMap());
    }

    /**
     * List all Client Role Assignments Lists all roles assigned to a Client Application identified by
     * &#x60;clientId&#x60;
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ListGroupAssignedRoles200ResponseInner
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ListGroupAssignedRoles200ResponseInner listRolesForClient(String clientId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling listRolesForClient");
        }

        // create path and map variables
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles".replaceAll("\\{" + "clientId" + "\\}",
                apiClient.escapeString(clientId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ListGroupAssignedRoles200ResponseInner> localVarReturnType = new TypeReference<ListGroupAssignedRoles200ResponseInner>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve a Client Role Retrieves a Role Assignment (identified by &#x60;roleAssignmentId&#x60;) for a Client
     * Application (identified by &#x60;clientId&#x60;)
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     *
     * @return ListGroupAssignedRoles200ResponseInner
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ListGroupAssignedRoles200ResponseInner retrieveClientRole(String clientId, String roleAssignmentId)
            throws ApiException {
        return this.retrieveClientRole(clientId, roleAssignmentId, Collections.emptyMap());
    }

    /**
     * Retrieve a Client Role Retrieves a Role Assignment (identified by &#x60;roleAssignmentId&#x60;) for a Client
     * Application (identified by &#x60;clientId&#x60;)
     *
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ListGroupAssignedRoles200ResponseInner
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ListGroupAssignedRoles200ResponseInner retrieveClientRole(String clientId, String roleAssignmentId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling retrieveClientRole");
        }

        // verify the required parameter 'roleAssignmentId' is set
        if (roleAssignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleAssignmentId' when calling retrieveClientRole");
        }

        // create path and map variables
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}"
                .replaceAll("\\{" + "clientId" + "\\}", apiClient.escapeString(clientId.toString()))
                .replaceAll("\\{" + "roleAssignmentId" + "\\}", apiClient.escapeString(roleAssignmentId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ListGroupAssignedRoles200ResponseInner> localVarReturnType = new TypeReference<ListGroupAssignedRoles200ResponseInner>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
