/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.CatalogApplication;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.Group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class RoleBTargetAdminApi {

    private ApiClient apiClient;

    public RoleBTargetAdminApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleBTargetAdminApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Assign all Apps as Target to Role Assigns all Apps as Target to Role
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void assignAllAppsAsTargetToRoleForUser(String userId, String roleAssignmentId) throws ApiException {
        this.assignAllAppsAsTargetToRoleForUser(userId, roleAssignmentId, Collections.emptyMap());
    }

    /**
     * Assign all Apps as Target to Role Assigns all Apps as Target to Role
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void assignAllAppsAsTargetToRoleForUser(String userId, String roleAssignmentId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling assignAllAppsAsTargetToRoleForUser");
        }

        // verify the required parameter 'roleAssignmentId' is set
        if (roleAssignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleAssignmentId' when calling assignAllAppsAsTargetToRoleForUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/roles/{roleAssignmentId}/targets/catalog/apps"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "roleAssignmentId" + "\\}", apiClient.escapeString(roleAssignmentId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Assign an Admin Role Application Instance Target Assigns an app instance target to an &#x60;APP_ADMIN&#x60; Role
     * Assignment to an admin User. When you assign the first OIN app or app instance target, you reduce the scope of
     * the Role Assignment. The Role no longer applies to all app targets, but applies only to the specified target.
     * &gt; **Note:** You can target a mixture of both OIN app and app instance targets, but can&#39;t assign
     * permissions to manage all instances of an OIN app and then assign a subset of permission to the same OIN app.
     * &gt; For example, you can&#39;t specify that an admin has access to manage all instances of the Salesforce app
     * and then also manage specific configurations of the Salesforce app.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param appName
     *            Application name for the app type (required)
     * @param appId
     *            Application ID (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void assignAppInstanceTargetToAppAdminRoleForUser(String userId, String roleAssignmentId, String appName,
            String appId) throws ApiException {
        this.assignAppInstanceTargetToAppAdminRoleForUser(userId, roleAssignmentId, appName, appId,
                Collections.emptyMap());
    }

    /**
     * Assign an Admin Role Application Instance Target Assigns an app instance target to an &#x60;APP_ADMIN&#x60; Role
     * Assignment to an admin User. When you assign the first OIN app or app instance target, you reduce the scope of
     * the Role Assignment. The Role no longer applies to all app targets, but applies only to the specified target.
     * &gt; **Note:** You can target a mixture of both OIN app and app instance targets, but can&#39;t assign
     * permissions to manage all instances of an OIN app and then assign a subset of permission to the same OIN app.
     * &gt; For example, you can&#39;t specify that an admin has access to manage all instances of the Salesforce app
     * and then also manage specific configurations of the Salesforce app.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param appName
     *            Application name for the app type (required)
     * @param appId
     *            Application ID (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void assignAppInstanceTargetToAppAdminRoleForUser(String userId, String roleAssignmentId, String appName,
            String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling assignAppInstanceTargetToAppAdminRoleForUser");
        }

        // verify the required parameter 'roleAssignmentId' is set
        if (roleAssignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleAssignmentId' when calling assignAppInstanceTargetToAppAdminRoleForUser");
        }

        // verify the required parameter 'appName' is set
        if (appName == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appName' when calling assignAppInstanceTargetToAppAdminRoleForUser");
        }

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling assignAppInstanceTargetToAppAdminRoleForUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}/{appId}"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "roleAssignmentId" + "\\}", apiClient.escapeString(roleAssignmentId.toString()))
                .replaceAll("\\{" + "appName" + "\\}", apiClient.escapeString(appName.toString()))
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Assign an Admin Role Application Target Assigns an OIN app target for an &#x60;APP_ADMIN&#x60; Role Assignment to
     * an admin User. When you assign the first app target, you reduce the scope of the Role Assignment. The Role no
     * longer applies to all app targets, but applies only to the specified target. Assigning an OIN app target
     * overrides any existing app instance targets of the OIN app. For example, if a user was assigned to administer a
     * specific Facebook instance, a successful request to add an OIN app target with &#x60;facebook&#x60; for
     * &#x60;appName&#x60; makes that user the administrator for all Facebook instances.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param appName
     *            Application name for the app type (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void assignAppTargetToAdminRoleForUser(String userId, String roleAssignmentId, String appName)
            throws ApiException {
        this.assignAppTargetToAdminRoleForUser(userId, roleAssignmentId, appName, Collections.emptyMap());
    }

    /**
     * Assign an Admin Role Application Target Assigns an OIN app target for an &#x60;APP_ADMIN&#x60; Role Assignment to
     * an admin User. When you assign the first app target, you reduce the scope of the Role Assignment. The Role no
     * longer applies to all app targets, but applies only to the specified target. Assigning an OIN app target
     * overrides any existing app instance targets of the OIN app. For example, if a user was assigned to administer a
     * specific Facebook instance, a successful request to add an OIN app target with &#x60;facebook&#x60; for
     * &#x60;appName&#x60; makes that user the administrator for all Facebook instances.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param appName
     *            Application name for the app type (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void assignAppTargetToAdminRoleForUser(String userId, String roleAssignmentId, String appName,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling assignAppTargetToAdminRoleForUser");
        }

        // verify the required parameter 'roleAssignmentId' is set
        if (roleAssignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleAssignmentId' when calling assignAppTargetToAdminRoleForUser");
        }

        // verify the required parameter 'appName' is set
        if (appName == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appName' when calling assignAppTargetToAdminRoleForUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "roleAssignmentId" + "\\}", apiClient.escapeString(roleAssignmentId.toString()))
                .replaceAll("\\{" + "appName" + "\\}", apiClient.escapeString(appName.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Assign an Admin Role Group Target Assigns a Group target for a &#x60;USER_ADMIN&#x60;,
     * &#x60;HELP_DESK_ADMIN&#x60;, or &#x60;GROUP_MEMBERSHIP_ADMIN&#x60; Role Assignment to an admin User. When you
     * assign the first Group target, you reduce the scope of the Role Assignment. The Role no longer applies to all
     * targets but applies only to the specified target.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void assignGroupTargetToUserRole(String userId, String roleAssignmentId, String groupId)
            throws ApiException {
        this.assignGroupTargetToUserRole(userId, roleAssignmentId, groupId, Collections.emptyMap());
    }

    /**
     * Assign an Admin Role Group Target Assigns a Group target for a &#x60;USER_ADMIN&#x60;,
     * &#x60;HELP_DESK_ADMIN&#x60;, or &#x60;GROUP_MEMBERSHIP_ADMIN&#x60; Role Assignment to an admin User. When you
     * assign the first Group target, you reduce the scope of the Role Assignment. The Role no longer applies to all
     * targets but applies only to the specified target.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void assignGroupTargetToUserRole(String userId, String roleAssignmentId, String groupId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling assignGroupTargetToUserRole");
        }

        // verify the required parameter 'roleAssignmentId' is set
        if (roleAssignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleAssignmentId' when calling assignGroupTargetToUserRole");
        }

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'groupId' when calling assignGroupTargetToUserRole");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/roles/{roleAssignmentId}/targets/groups/{groupId}"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "roleAssignmentId" + "\\}", apiClient.escapeString(roleAssignmentId.toString()))
                .replaceAll("\\{" + "groupId" + "\\}", apiClient.escapeString(groupId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * List all Admin Role Application Targets Lists all app targets for an &#x60;APP_ADMIN&#x60; Role Assigned to a
     * User. The response is a list that includes OIN-cataloged apps or app instances. The response payload for an app
     * instance contains the &#x60;id&#x60; property, but an OIN-cataloged app payload doesn&#39;t.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param after
     *            (optional)
     * @param limit
     *            (optional, default to 20)
     *
     * @return List&lt;CatalogApplication&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<CatalogApplication> listApplicationTargetsForApplicationAdministratorRoleForUser(String userId,
            String roleAssignmentId, String after, Integer limit) throws ApiException {
        return this.listApplicationTargetsForApplicationAdministratorRoleForUser(userId, roleAssignmentId, after, limit,
                Collections.emptyMap());
    }

    /**
     * List all Admin Role Application Targets Lists all app targets for an &#x60;APP_ADMIN&#x60; Role Assigned to a
     * User. The response is a list that includes OIN-cataloged apps or app instances. The response payload for an app
     * instance contains the &#x60;id&#x60; property, but an OIN-cataloged app payload doesn&#39;t.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param after
     *            (optional)
     * @param limit
     *            (optional, default to 20)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;CatalogApplication&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<CatalogApplication> listApplicationTargetsForApplicationAdministratorRoleForUser(String userId,
            String roleAssignmentId, String after, Integer limit, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling listApplicationTargetsForApplicationAdministratorRoleForUser");
        }

        // verify the required parameter 'roleAssignmentId' is set
        if (roleAssignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleAssignmentId' when calling listApplicationTargetsForApplicationAdministratorRoleForUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/roles/{roleAssignmentId}/targets/catalog/apps"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "roleAssignmentId" + "\\}", apiClient.escapeString(roleAssignmentId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<CatalogApplication>> localVarReturnType = new TypeReference<List<CatalogApplication>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Admin Role Group Targets Lists all Group targets for a &#x60;USER_ADMIN&#x60;,
     * &#x60;HELP_DESK_ADMIN&#x60;, or &#x60;GROUP_MEMBERSHIP_ADMIN&#x60; Role Assignment to an admin User. If the Role
     * isn&#39;t scoped to specific Group targets, an empty array &#x60;[]&#x60; is returned.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param after
     *            (optional)
     * @param limit
     *            (optional, default to 20)
     *
     * @return List&lt;Group&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Group> listGroupTargetsForRole(String userId, String roleAssignmentId, String after, Integer limit)
            throws ApiException {
        return this.listGroupTargetsForRole(userId, roleAssignmentId, after, limit, Collections.emptyMap());
    }

    /**
     * List all Admin Role Group Targets Lists all Group targets for a &#x60;USER_ADMIN&#x60;,
     * &#x60;HELP_DESK_ADMIN&#x60;, or &#x60;GROUP_MEMBERSHIP_ADMIN&#x60; Role Assignment to an admin User. If the Role
     * isn&#39;t scoped to specific Group targets, an empty array &#x60;[]&#x60; is returned.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param after
     *            (optional)
     * @param limit
     *            (optional, default to 20)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;Group&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Group> listGroupTargetsForRole(String userId, String roleAssignmentId, String after, Integer limit,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listGroupTargetsForRole");
        }

        // verify the required parameter 'roleAssignmentId' is set
        if (roleAssignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleAssignmentId' when calling listGroupTargetsForRole");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/roles/{roleAssignmentId}/targets/groups"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "roleAssignmentId" + "\\}", apiClient.escapeString(roleAssignmentId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<Group>> localVarReturnType = new TypeReference<List<Group>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Unassign an Admin Role Application Instance Target Unassigns an app instance target from an &#x60;APP_ADMIN&#x60;
     * Role Assignment to an admin User. &gt; **Note:** You can&#39;t remove the last app instance target from a Role
     * Assignment since this causes an exception. &gt; If you need a Role Assignment that applies to all apps, delete
     * the &#x60;APP_ADMIN&#x60; Role Assignment and recreate a new one.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param appName
     *            Application name for the app type (required)
     * @param appId
     *            Application ID (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unassignAppInstanceTargetFromAdminRoleForUser(String userId, String roleAssignmentId, String appName,
            String appId) throws ApiException {
        this.unassignAppInstanceTargetFromAdminRoleForUser(userId, roleAssignmentId, appName, appId,
                Collections.emptyMap());
    }

    /**
     * Unassign an Admin Role Application Instance Target Unassigns an app instance target from an &#x60;APP_ADMIN&#x60;
     * Role Assignment to an admin User. &gt; **Note:** You can&#39;t remove the last app instance target from a Role
     * Assignment since this causes an exception. &gt; If you need a Role Assignment that applies to all apps, delete
     * the &#x60;APP_ADMIN&#x60; Role Assignment and recreate a new one.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param appName
     *            Application name for the app type (required)
     * @param appId
     *            Application ID (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unassignAppInstanceTargetFromAdminRoleForUser(String userId, String roleAssignmentId, String appName,
            String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling unassignAppInstanceTargetFromAdminRoleForUser");
        }

        // verify the required parameter 'roleAssignmentId' is set
        if (roleAssignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleAssignmentId' when calling unassignAppInstanceTargetFromAdminRoleForUser");
        }

        // verify the required parameter 'appName' is set
        if (appName == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appName' when calling unassignAppInstanceTargetFromAdminRoleForUser");
        }

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling unassignAppInstanceTargetFromAdminRoleForUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}/{appId}"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "roleAssignmentId" + "\\}", apiClient.escapeString(roleAssignmentId.toString()))
                .replaceAll("\\{" + "appName" + "\\}", apiClient.escapeString(appName.toString()))
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Unassign an Admin Role Application Target Unassigns an OIN app target from an &#x60;APP_ADMIN&#x60; Role
     * Assignment to an admin User. &gt; **Note:** You can&#39;t remove the last OIN app target from a Role Assignment
     * since this causes an exception. &gt; If you need a Role Assignment that applies to all apps, delete the
     * &#x60;APP_ADMIN&#x60; Role Assignment to the User and recreate a new one.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param appName
     *            Application name for the app type (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unassignAppTargetFromAppAdminRoleForUser(String userId, String roleAssignmentId, String appName)
            throws ApiException {
        this.unassignAppTargetFromAppAdminRoleForUser(userId, roleAssignmentId, appName, Collections.emptyMap());
    }

    /**
     * Unassign an Admin Role Application Target Unassigns an OIN app target from an &#x60;APP_ADMIN&#x60; Role
     * Assignment to an admin User. &gt; **Note:** You can&#39;t remove the last OIN app target from a Role Assignment
     * since this causes an exception. &gt; If you need a Role Assignment that applies to all apps, delete the
     * &#x60;APP_ADMIN&#x60; Role Assignment to the User and recreate a new one.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param appName
     *            Application name for the app type (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unassignAppTargetFromAppAdminRoleForUser(String userId, String roleAssignmentId, String appName,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling unassignAppTargetFromAppAdminRoleForUser");
        }

        // verify the required parameter 'roleAssignmentId' is set
        if (roleAssignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleAssignmentId' when calling unassignAppTargetFromAppAdminRoleForUser");
        }

        // verify the required parameter 'appName' is set
        if (appName == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appName' when calling unassignAppTargetFromAppAdminRoleForUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "roleAssignmentId" + "\\}", apiClient.escapeString(roleAssignmentId.toString()))
                .replaceAll("\\{" + "appName" + "\\}", apiClient.escapeString(appName.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Unassign an Admin Role Group Target Unassigns a Group target from a &#x60;USER_ADMIN&#x60;,
     * &#x60;HELP_DESK_ADMIN&#x60;, or &#x60;GROUP_MEMBERSHIP_ADMIN&#x60; Role Assignment to an admin User. &gt;
     * **Note:** You can&#39;t remove the last Group target from a Role Assignment since this causes an exception. &gt;
     * If you need a Role Assignment that applies to all Groups, delete the Role Assignment to the User and recreate a
     * new one.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unassignGroupTargetFromUserAdminRole(String userId, String roleAssignmentId, String groupId)
            throws ApiException {
        this.unassignGroupTargetFromUserAdminRole(userId, roleAssignmentId, groupId, Collections.emptyMap());
    }

    /**
     * Unassign an Admin Role Group Target Unassigns a Group target from a &#x60;USER_ADMIN&#x60;,
     * &#x60;HELP_DESK_ADMIN&#x60;, or &#x60;GROUP_MEMBERSHIP_ADMIN&#x60; Role Assignment to an admin User. &gt;
     * **Note:** You can&#39;t remove the last Group target from a Role Assignment since this causes an exception. &gt;
     * If you need a Role Assignment that applies to all Groups, delete the Role Assignment to the User and recreate a
     * new one.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unassignGroupTargetFromUserAdminRole(String userId, String roleAssignmentId, String groupId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling unassignGroupTargetFromUserAdminRole");
        }

        // verify the required parameter 'roleAssignmentId' is set
        if (roleAssignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleAssignmentId' when calling unassignGroupTargetFromUserAdminRole");
        }

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'groupId' when calling unassignGroupTargetFromUserAdminRole");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/roles/{roleAssignmentId}/targets/groups/{groupId}"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "roleAssignmentId" + "\\}", apiClient.escapeString(roleAssignmentId.toString()))
                .replaceAll("\\{" + "groupId" + "\\}", apiClient.escapeString(groupId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
